/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "library.h"

static gboolean
must_reformat(char *field_string)
{
	size_t length;

	length = strlen(field_string);
	if (field_string[length - 1] != '&')
		return TRUE;
	else
		return FALSE;
}

static char *
get_command_string(char *field)
{
	char *new_field;

	ARIFB(must_reformat(field))
		ar_asprintf(&new_field, "%s &", field);
	else
	ar_asprintf(&new_field, "%s", field);

	return new_field;
}

int
antiright_system(char *field_string)
{
	/* Ensure that FIELD_STRING is not empty.  */
	ARIFP(field_string)
	{
		char *command;

		command = get_command_string(field_string);

		if (system(command) == 0)
		{
			g_free(command);

			return EXIT_SUCCESS;
		}
		else
		{
			g_free(command);
			ARWARN("command could not be executed");

			return EXIT_FAILURE;
		}
	}
	else
	{
		/* The user input is empty, so generate an error.  */
		ARWARN("field_string is NULL");
		return (EXIT_FAILURE);
	}
}

int
vsysprintf(const char *format, va_list list)
{
	char *command;
	int return_value;

	g_vasprintf(&command, format, list);
	return_value = antiright_system(command);
	g_free(command);

	return (return_value);
}

int
sysprintf(const char *format,...)
{
	va_list list;
	int return_value;

	va_start(list, format);
	return_value = vsysprintf(format, list);
	va_end(list);
	return (return_value);
}
