/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
gsh_message_dialog(GSH * gsh, GtkMessageType type, const gchar *text)
	__attribute__((noreturn));

static void
gsh_font_dialog() __attribute__((noreturn));

static void
gsh_color_dialog() __attribute__((noreturn));

static void
gsh_message_dialog(GSH * gsh, GtkMessageType type, const gchar *text)
{
	gtk_dialog_run(GTK_DIALOG(gtk_message_dialog_new(GTK_WINDOW(
		gsh->widgets.window), GTK_DIALOG_DESTROY_WITH_PARENT, type,
		GTK_BUTTONS_CLOSE, (gchar *) text)));

	exit(0);
}

#define GMD gsh_message_dialog

#define ERROR_DIALOG(gsh, message) \
	GMD(gsh, GTK_MESSAGE_ERROR, message)
#define INFO_DIALOG(gsh, message) \
	GMD(gsh, GTK_MESSAGE_INFO, message)
#define WARNING_DIALOG(gsh, message) \
	GMD(gsh, GTK_MESSAGE_WARNING, message)

static void
select_font(GtkWidget * dialog)
{
	gchar *font;

	font = gtk_font_selection_dialog_get_font_name(
			GTK_FONT_SELECTION_DIALOG(dialog));
	g_print("%s\n", font);
	g_free(font);
}

static void
gsh_font_dialog()
{
	GtkWidget *dialog;

	dialog = gtk_font_selection_dialog_new("Font Selector");
	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK)
		select_font(dialog);

	exit(0);
}

static void
color_select(GtkWidget * dialog)
{
	GdkColor color;

	gtk_color_selection_get_current_color( GTK_COLOR_SELECTION(
		GTK_COLOR_SELECTION_DIALOG(dialog)->colorsel), &color);
	g_print("#%x%x%x\n", color.red, color.green, color.blue);
}

static void
gsh_color_dialog()
{
	GtkWidget *dialog;

	dialog = gtk_color_selection_dialog_new("Color Selector");

	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK)
		color_select(dialog);

	exit(0);
}

void
gsh_handle_dialog_arguments(GSH * gsh, const gint argc, const gchar **argv,
			    gint *counter)
{
#ifndef DEBUG
	UNUSED(argc);
#endif /* DEBUG */
	g_assert(strlen(argv[(*counter)]) > 2);
#ifdef DEBUG
	ARPASSERT(gsh);
#endif /* DEBUG */
	switch (argv[(*counter)][2])
	{
	case 'a':
		gsh_about_dialog();
		break;
	case 'c':		/* Color Selection */
		gsh_color_dialog();
		break;
	case 'D':		/* Folder Creation Selector */
		GSH_FOLDER_CREATE_DIALOG(gsh);
		break;
	case 'd':		/* Folder Selector */
		GSH_FOLDER_OPEN_DIALOG(gsh);
		break;
	case 'e':		/* Error Message */
		GSH_COUNT(argc, counter);
		ERROR_DIALOG(gsh, argv[*counter]);
		break;
	case 'F':		/* Font Selection */
		gsh_font_dialog();
		break;
	case 'f':
		/* File Selection */
		GSH_FILE_OPEN_DIALOG(gsh);
		break;
	case 'i':		/* Information */
		GSH_COUNT(argc, counter);
		INFO_DIALOG(gsh, argv[*counter]);
		break;
	case 's':		/* Filename Selection for Saving */
		
		GSH_FILE_SAVE_DIALOG(gsh);
		break;
	case 'w':		/* Warning */
		GSH_COUNT(argc, counter);
		WARNING_DIALOG(gsh, argv[*counter]);
		break;
	default:
		ARWARN("invalid dialog option");
	}
}
