/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
set_font(GtkWidget * widget, const gchar * font)
{
	PangoFontDescription *font_desc;
#define PFD(op, arg) pango_font_description_##op(arg)
	font_desc = PFD(from_string, font);
	gtk_widget_modify_font(widget, font_desc);
	PFD(free, font_desc);
}

void
gsh_widget_set_font(GtkWidget *widget, const gchar *font)
{
#ifdef DEBUG
	ARPASSERT(widget);
#endif /* DEBUG */
	if(!font) /* Allowed assignmet for uninitialized const var.  */
		font="Mono 12";
#ifdef HAVE_VTE
	if(VTE_IS_TERMINAL(widget))
		vte_terminal_set_font_from_string(VTE_TERMINAL(widget), font);
#endif /* HAVE_VTE */
	else /* Not a terminal.  */
		set_font(widget, font);
}

