/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
set_up_containers_for_menu_item_row(GtkWidget * button, GtkWidget * hrow, 
	GtkWidget * label, GtkWidget * image)
{
	GSHCA(button, hrow);
	GSHCA_TIGHT(hrow, image);
	GSHCA(hrow, label);
}

static void
setup_row_for_menu_item_image(struct GSH * gsh, GtkWidget * label,
	GtkWidget * image)
{
	GtkWidget * hrow;

	hrow=gtk_hbox_new(FALSE, 2);
	set_up_containers_for_menu_item_row(gsh->widgets.button, hrow,
		label, image);
	gtk_widget_show(hrow);
}

static void
set_menu_item_image(struct GSH * gsh, GtkWidget * image)
{
	GtkWidget * label;

	label=gtk_bin_get_child(GTK_BIN(gsh->widgets.button));
	gtk_widget_ref(label);
	gtk_container_remove(GTK_CONTAINER(gsh->widgets.button), label);
	setup_row_for_menu_item_image(gsh, label, image);
	gtk_widget_show(image);
	gtk_widget_show(label);
}

static void
set_button_image(GtkWidget * button, GtkWidget * image)
{
	gtk_button_set_image(GTK_BUTTON(button), image);
	gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);
}

/* Get an image from the antiright icon distribution or the GTK stock
   icon set.  */
static GtkWidget * 
get_default_image(struct GSH * gsh, const gchar * name)
{
	gchar * prefixed_name;
	GtkWidget * image;

	ar_asprintf(&prefixed_name, PREFIX "/share/ACE-desktop/icons/%s", 
			name);
	/* Determine whether to use the file name constructed in prefixed_name
	 * or to use a stock icon (tried if the file does not exit).  */
	image = g_file_test(prefixed_name, G_FILE_TEST_EXISTS)
		? gtk_image_new_from_file(prefixed_name)
		: gtk_image_new_from_stock(name, gsh->icon_size);
	g_free(prefixed_name);

	return image;
}

GtkWidget *
gsh_get_image(GSH * gsh, const gchar * name)
{
	return g_file_test(name, G_FILE_TEST_EXISTS)
		? gtk_image_new_from_file(name)
		: get_default_image(gsh, name);
}

void
gsh_image_button(struct GSH * gsh, char *command, char *name)
{
	GtkWidget * image;

	image = gsh_get_image(gsh, name);
	$(gsh, add.button, command);
	ARIFP(image)
	{
		gtk_widget_show(image);
		if(!GTK_IS_MENU_BAR(gsh->rows->v) 
		   && !GTK_IS_MENU_ITEM(gsh->rows->v)
	   	   && !GTK_IS_MENU(gsh->rows->v))
		{
			set_button_image(gsh->widgets.button, image);
		}
		else
			set_menu_item_image(gsh, image);
	}
}

