/*
  AntiRight
  (c) 2002-2006 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
gsh_update_each(gpointer data, gpointer user_data)
{
	UNUSED(user_data);
	/*
	 * Ensure that the argument containing the structure is not
	 * empty.
	 */
#ifdef DEBUG
	ARWIFNP(data)
	{
#endif /* DEBUG */
		struct GSHUpdatedWidget *item;

		/*
		 * Assign data to structure and call function pointer
		 * with parameters.
		 */
		item = (struct GSHUpdatedWidget *) data;
#ifdef DEBUG
		ARPASSERT(item->update);
#endif /* DEBUG */
		$(item, update);
#ifdef DEBUG
	}
#endif /* DEBUG */
}

static gint
gsh_perform_updates(gpointer data)
{
	struct GSHUpdateManager * updaters;

#ifdef DEBUG
	ARBUG("gsh_perform_updates()");
#endif				/* DEBUG */

	updaters = (struct GSHUpdateManager *) data;


#ifdef DEBUG
	if (updaters && updaters->list)
#endif /* DEBUG */
		g_slist_foreach(updaters->list, gsh_update_each, NULL);
#ifdef DEBUG
	else
	{
		ARWARN("data invalid, operation not performed.");
		return FALSE;
	}
#endif /* DEBUG */

	return TRUE;
}

static void
gsh_GSHUpdateManager_start(struct GSHUpdateManager * updaters)
{
#ifdef DEBUG
	ARBUG("gsh_start_updates()");
#endif				/* DEBUG */
	if(updaters->updating)
		return;
	else
		updaters->updating=TRUE;
#ifdef DEBUG
	ARWIFNP (updaters)
	{
#endif /* DEBUG */
		(void) gsh_perform_updates(updaters);
		(void) g_timeout_add(updaters->period, gsh_perform_updates,
				     updaters);
#ifdef DEBUG
	}
#endif /* DEBUG */
}

static void
gsh_GSHUpdateManager_add(struct GSHUpdateManager * updaters, 
	struct GSHUpdatedWidget * item)
{

#ifdef DEBUG
	ARBUG("gsh_append_updater()");

	if (ARPBOOL(updaters) && ARPBOOL(item))
#endif				/* DEBUG */
		updaters->list = g_slist_prepend(updaters->list, item);
	/* Begin updating, if necessary.  */
	gsh_GSHUpdateManager_start(updaters);
#ifdef DEBUG
	ARBUG("end gsh_append_updater()");
#endif				/* DEBUG */
}


static void
gsh_delete_each_updater(gpointer data, gpointer user_data)
{
	struct GSHUpdatedWidget * item;

	UNUSED(user_data);
	item=(struct GSHUpdatedWidget *)data;
	$(item, delete);
}

static void
gsh_delete_GSHUpdateManager(struct GSHUpdateManager * updaters)
{
	g_slist_foreach(updaters->list, gsh_delete_each_updater, NULL);
	g_slist_free(updaters->list);
	g_free(updaters);
}

/* Setup method function pointer assignments.  */
static void
assign_methods(struct GSHUpdateManager * update)
{
	update->delete=&gsh_delete_GSHUpdateManager;
	update->add=&gsh_GSHUpdateManager_add;
}

/* Setup member data fields.  */
static void
initialize_fields(struct GSHUpdateManager * update)
{
	update->period = 1000;
	update->list = (GSList *) NULL;
	update->updating=FALSE;
}

static void
setup(struct GSHUpdateManager * update)
{
	assign_methods(update);
	initialize_fields(update);
}

struct GSHUpdateManager *
gsh_new_GSHUpdateManager()
{
	struct GSHUpdateManager * updater;
	
	updater=xmalloc(sizeof(struct GSHUpdateManager));
	setup(updater);

	return updater;
}


