/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "library.h"

static void
ar_delete_ARDimensions(ARDimensions * this)
{
	xfree(this);
}

static void
set_dimensions(ARDimensions * this, const gint x, const gint y, 
	const guint width, const guint height)
{
	this->x=(gint)x;
	this->y=(gint)y;
	this->height=(guint)height;
	this->width=(guint)width;
}

static void
setup_methods(ARDimensions * dimensions)
{
	dimensions->delete=&ar_delete_ARDimensions;
	dimensions->set=&set_dimensions;
}

ARDimensions *
ar_new_ARDimensions()
{
	ARDimensions * dimensions;

	dimensions=xmalloc(sizeof(ARDimensions));
	setup_methods(dimensions);
	
	return dimensions;
}

