/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef AR_VECTOR_H
#define AR_VECTOR_H

struct
ARObject
{
	gpointer __data;
	void (*delete)(struct ARObject *);
	void (*set_data)(struct ARObject *, gpointer);
	gpointer (*get_data)(struct ARObject *);
};

void
ar_set_data_ARObject(struct ARObject * this, gpointer data);

gpointer
ar_get_data_ARObject(struct ARObject * this);

struct ARObject *
ar_new_ARObject();

void
ar_delete_ARObject(struct ARObject * object);

struct
ARVector
{
	/* Element data reference.  */
	struct ARObject ** __data;
	/* Pointer cells used.  */
	guint __elements;
	/* Total memory allocated.  */
	guint __size;
	/* Methods.  */
	/* This should search for a NULL element before
	   appending to end.  */
	void (*add)(struct ARVector *, gpointer);
	/* Get an item by an an index.  */
	gpointer (*get_item)(struct ARVector * this, guint);
	guint (*get_length)(struct ARVector * this);
	/* This returns a pointer to the cell containing a
	   key/ID of KEY.  */
	gpointer (*find_item)(struct ARVector *, gpointer);
	/* Return the index of item indicated by KEY gpointer.  */
	guint (*find_index)(struct ARVector *, gpointer);
	/* This should not decrease the elements count,
	   rather, the element should be marked with NULL.  */
	void (*delete_key)(struct ARVector *, gpointer);
	/* This reinitializeds the vector with two times the
	   amount of non-NULL elements.  Effectively, it
	   performs mark-and-sweep.  */
	void (*__sweep)(struct ARVector *);
};

#endif /* AR_VECTOR_H */

