/*
  AntiRight
  (c) 2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"
#include <time.h>

#define GSH_CLOCK_TIME_STRING_SIZE 20

static void
get_time_string(gchar * time_string)
{
	time_t time_value;

	(void)time(&time_value);
	{
		struct tm split_time;

		(void)localtime_r(&time_value, &split_time);
#define GSHTM(element) split_time.tm_##element
		(void)snprintf(time_string, 
			GSH_CLOCK_TIME_STRING_SIZE,
			"%.2d/%.2d/%.2d\n%.2d:%.2d:%.2d",
			GSHTM(mon)+1, GSHTM(mday), GSHTM(year)%100,
			GSHTM(hour), GSHTM(min), GSHTM(sec));
	}
}

static void
update_clock(const gchar * command, gpointer clock_pointer)
{
	gchar time_string[GSH_CLOCK_TIME_STRING_SIZE];

	get_time_string(time_string);
	gtk_label_set_text(GTK_LABEL((GtkWidget *)clock_pointer), time_string);
}

#define GSH_SET_CLOCK_COLORS(clock, event_box)\
	gsh_widget_set_color(event_box, "#223", FALSE);\
	gsh_widget_set_color(clock, "#dde", TRUE);
	

static GtkWidget *
setup_containers(GtkWidget * clock)
{
	GtkWidget * frame;

	gtk_widget_show(frame=gtk_frame_new(NULL));
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
	{ /* Setup event box, containment, and colors.  */
		GtkWidget * event_box;

		gtk_widget_show(event_box=gtk_event_box_new());
		GSHCA(frame, event_box);
		GSH_SET_CLOCK_COLORS(clock, event_box);
		GSHCA(event_box, clock);
	}

	return frame;
}

GtkWidget *
gsh_clock_new(GSH * gsh)
{
	GtkWidget * clock;
	
	gsh_widget_set_font(clock=gtk_label_new(NULL), "Mono 10");
	GSH_NEW_UPDATER(gsh, update_clock, clock);
	gtk_widget_show(clock);

	return setup_containers(clock);
}

