/*
  AntiRight

  Swallowing code written by Peter Amstutz <tetron@interreality.org>, 2003 GPL,
  	as part of gnome-swallow.
  (c) 2007 Jeffrey Bedard 
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"
#include <gdk/gdkx.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

static gboolean 
swallow(char* wantedWindow, Display* display, Screen* screen, Window hunger, 
	unsigned int* width, unsigned int* height)
{
    int ready = FALSE, i,k,l;
    unsigned int number_of_kids, number_of_subkids, number_of_subsubkids;
    Window root, parent, *children=NULL,*subchildren=NULL,*subsubchildren=NULL;
    Window victim;
    char *windowname;
    XWMHints *leader_change;
    int x, y;
    unsigned int junk;
    double start, now;
    struct timeval tv;
    char ret;

    if(! display) return FALSE;

    XSync (display, FALSE);

    gettimeofday(&tv, NULL);
    now = start = (double)tv.tv_sec + ((double)tv.tv_usec / 1000000.0);

    while (ready == FALSE && now < (start + 10.0))
    {
        if (children != (Window *) NULL) XFree (children);

        XQueryTree (display, RootWindowOfScreen (screen), &root,
                    &parent, &children, &number_of_kids);
        for (i = 0; i < number_of_kids; i++)
        {
            if (0 != XFetchName (display, children[i], &windowname))
            {
                if (!strcmp (windowname, wantedWindow))
                {
                    ready = TRUE;
                    victim = children[i];
                    fprintf(stderr,"Found It\n");
                }
                else
                    fprintf(stderr,"Found %s\n",windowname);
                XFree (windowname);
            }
            /*for each of these toplevel windows check their children*/
            /*if it wasnt found*/
            if (ready == FALSE)
            {
                if (subchildren != (Window *) NULL)
                    XFree (subchildren);
                XQueryTree (display, children[i], &root,
                            &parent, &subchildren, &number_of_subkids);
                for (k = 0; k < number_of_subkids; k++)
                {
                    if (0 != XFetchName (display, subchildren[k], &windowname))
                    {
                        if (!strcmp (windowname, wantedWindow))
                        {
                            ready = TRUE;
                            victim = subchildren[k];
                            fprintf(stderr,"Found %s!!!\n",windowname);
                        }
                        else
                            fprintf(stderr,"Found %s\n",windowname);
                        XFree (windowname);
                    }
                    /**/
                    /*for each of these sublevel windows check their children*/
                    /*if it wasnt found*/
                    if (ready == FALSE)
                    {
                        if (subsubchildren != (Window *) NULL)
                            XFree (subsubchildren);
                        XQueryTree (display, subchildren[k], &root,
                                    &parent, &subsubchildren, &number_of_subsubkids);
                        for (l = 0; l < number_of_subsubkids; l++)
                        {
                            if (0 != XFetchName (display, subsubchildren[l], &windowname))
                            {
                                if (!strcmp (windowname, wantedWindow))
                                {
                                    ready = TRUE;
                                    victim = subsubchildren[l];
                                    fprintf(stderr,"Found %s!!!\n",windowname);
                                }
                                else
                                    fprintf(stderr,"Found %s\n",windowname);
                                XFree (windowname);
                            }
                        }
                    }
                }
            }
        }
        fprintf(stderr,"Loop");
        gtk_main_iteration_do(FALSE);

        gettimeofday(&tv, NULL);
        now = (double)tv.tv_sec + ((double)tv.tv_usec / 1000000.0);
    }

    if(ready) {
        XSync (display, FALSE);
        XUnmapWindow (display, victim);
        XIconifyWindow (display, victim, XScreenNumberOfScreen (screen));
        XWithdrawWindow (display, victim, XScreenNumberOfScreen (screen));
        XMoveWindow (display, victim, -9999, -9999);

        leader_change = XGetWMHints(display, victim);
        if(leader_change) {
            leader_change->flags = (leader_change->flags | WindowGroupHint);
            leader_change->window_group = RootWindowOfScreen(screen);
        }
        XSetWindowBorderWidth (display, victim, 0);

        XSync (display, FALSE);

        sleep(1);

        XReparentWindow (display, victim, hunger, -9999, -9999);

        XGetGeometry (display, victim, &root, &x, &y, width, height, &junk, &junk);
        XMoveWindow (display, victim, 0, 0);
        if(leader_change) XSetWMHints(display, victim, leader_change);
        XMapWindow (display, victim);
        XSync (display, FALSE);

        ret = TRUE;
    } else {
        ret = FALSE;
    }

    if (children != (Window *) NULL)
        XFree (children);
    if (subchildren != (Window *) NULL)
        XFree (subchildren);
    if (subsubchildren != (Window *) NULL)
        XFree (subsubchildren);

    return ret;
}

void
gsh_swallow_app(GtkWidget * target, gchar * source_name)
{
	GdkWindow * window = target->window;

	swallow(source_name, 
		GDK_WINDOW_XDISPLAY(window),
		GDK_SCREEN_XSCREEN(gtk_widget_get_screen(target)),
		GDK_WINDOW_XWINDOW(window), 
		(unsigned int *)&(target->requisition.width), 
		(unsigned int *)&(target->requisition.height));
	gtk_widget_set_size_request(target,
		target->requisition.width,
		target->requisition.height);
}

/* example
    if(swallow(ap->applet_name,
            GDK_DISPLAY_XDISPLAY(gdkdisplay),
            GDK_SCREEN_XSCREEN(gdkscreen),
            GDK_WINDOW_XWINDOW (GTK_WIDGET (ap->parentWidget)->window),
               &ap->width, &ap->height))
*/
