/*
  AntiRight
  (c) 2002-2005 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "library.h"

static void
ar_ARArguments_delete_contents(struct ARArguments * args)
{
	for(; args->argc>0; args->argc--)
		g_free(args->argv[args->argc-1]);
	g_free(args->argv);
}

static void
ar_delete_ARArguments(struct ARArguments * args)
{
	ar_ARArguments_delete_contents(args);
	g_free(args);
}

static void
ar_ARArguments_add(struct ARArguments * this, const gchar * item)
{
	this->argc++;
	this->argv=realloc(this->argv, sizeof(gchar*)*this->argc);
	this->argv[this->argc-1]=g_strdup(item);
}

static void
ar_ARArguments_add_as_first(struct ARArguments * this, const gchar * item)
{
	gchar * swap;

	ar_ARArguments_add(this, item);
	swap=this->argv[0];
	this->argv[0]=this->argv[this->argc-1];
	this->argv[this->argc-1]=swap;
}

static void
ar_ARArguments_setup(struct ARArguments * args)
{
	args->argc=0;
	args->argv=NULL;
	args->add=&ar_ARArguments_add;
	args->add_as_first=&ar_ARArguments_add_as_first;
	args->delete=&ar_delete_ARArguments;
}

struct ARArguments *
ar_new_ARArguments()
{
	struct ARArguments * args;

	args=g_malloc(sizeof(struct ARArguments));
	ar_ARArguments_setup(args);

	return args;
}
