/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "xshell.h"

unsigned long 
xsh_get_color(Display * display, 
	unsigned short r, unsigned short g, unsigned short b)
{
	XColor color;

	color.red=r*256;
	color.green=g*256;
	color.blue=b*256;
	color.flags=DoRed|DoGreen|DoBlue;
	XAllocColor(display, DefaultColormap(display, DefaultScreen(display)), 
		&color);

	return color.pixel;
}

void
xsh_set_foreground(Display * display, GC gc, unsigned long color)
{
	XGCValues values;

	/* Set up GC.  */
	values.foreground=color;
	XChangeGC(display, gc, GCForeground, &values);
}
