
#include "gtkshell.h"

static void
add_launcher(GSHQuickStart * this,
	GSH * gsh, const gchar * command, const gchar * icon_name)
{
	GtkWidget * button;

	gsh_image_button(gsh, (gchar *)command, (gchar *)icon_name);
	button=gsh->widgets.button;
	gsh_reparent_widget(button, gtk_widget_get_parent(button),
		this->__last_was_row1 ? this->__row2 : this->__row1);
	this->__last_was_row1=!this->__last_was_row1;
}

static void
delete(GSHQuickStart * this)
{
	gtk_widget_destroy(this->__column);
	g_free(this);
}

static GtkWidget *
getColumn(GSHQuickStart * this)
{
	return this->__column;
}

GSHQuickStart *
gsh_new_GSHQuickStart()
{
	GSHQuickStart * quickstart=g_malloc(sizeof(GSHQuickStart));
	GtkWidget * column=quickstart->__column=gtk_vbox_new(TRUE, 0);
	GtkWidget * row1=quickstart->__row1=gtk_hbox_new(TRUE, 0);
	GtkWidget * row2=quickstart->__row2=gtk_hbox_new(TRUE, 0);

	GSHCA(column, row1);
	GSHCA(column, row2);
	gtk_widget_show(row1);
	gtk_widget_show(row2);
	gtk_widget_show(column);
	quickstart->__last_was_row1=FALSE;
	quickstart->add=add_launcher;
	quickstart->delete=delete;
	quickstart->getColumn=getColumn;

	return quickstart;
}

