/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "gtkshell.h"

static void
gsh_delete_GSHUpdatedWidget(struct GSHUpdatedWidget * item)
{
	GSH_FREE_IF(item->command);
	g_free(item);
}

static void
gsh_GSHUpdatedWidget_update(struct GSHUpdatedWidget * item)
{
	/* Call function pointer specific to the updater type.  */
	item->function(item->command, item->widget);
}

struct GSHUpdatedWidget *
gsh_new_GSHUpdatedWidget(void (*function)(const gchar *, gpointer), 
	const gchar * command, GtkWidget * widget)
{
	struct GSHUpdatedWidget * updater;

	updater=xmalloc(sizeof(struct GSHUpdatedWidget));
	/* Assign method function pointers.  */
	updater->update=&gsh_GSHUpdatedWidget_update;
	updater->delete=&gsh_delete_GSHUpdatedWidget;
	/* Assign widget-specific update information, specifically
	 * the widget command, a pointer to the widget, and the widget's
	 * updater function.  */
	updater->command=(gchar *)command;
	updater->widget=widget;
	updater->function=function;

	return updater;
}


