/*
  AntiRight
  (c) 2002-2005 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef LIBAR_UTIL_H
#define LIBAR_UTIL_H

#define AR_TEXT_TO_FILE(filename, text)\
	g_file_set_contents(filename, text, strlen(text), NULL)

gpointer
xmalloc(size_t size);

void
xfree(gpointer data);

#define UNUSED(arg) /* undefined. */

typedef void(*ARActionFunction)(gint *, gchar **);

struct ARFunctionDictionary
{
	struct ARArguments * __data;
	void (*define)(struct ARFunctionDictionary *, const gchar *,
		ARActionFunction);
	ARActionFunction (*lookup)(struct ARFunctionDictionary *,
		const gchar *);
	void (*exec)(struct ARFunctionDictionary *, const gchar *,
		gint *, gchar **);
	void (*delete)(struct ARFunctionDictionary *);
};

struct ARFunctionDictionary *
ar_new_ARFunctionDictionary();

struct ARCommandLineParser
{
	struct ARArguments * __args;
	struct ARFunctionDictionary * __dict;
	void (*set_args)(struct ARCommandLineParser *, 
		const struct ARArguments * args);
	void (*parse)(struct ARCommandLineParser *);
	void (*delete)(struct ARCommandLineParser *);
};

struct ARCommandLineParser *
ar_new_ARCommandLineParser(struct ARFunctionDictionary * dict);

#endif
