/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "xshell.h"

static void
draw_label(XShell * xsh, XWidget * button)
{
	XSHButtonData * data = (XSHButtonData *)button->data;
	char * label=data->label;
	XShellGUI * gui = &(xsh->gui);
	Display * dpy = gui->display;
	GC gc = xsh->gui.gc;
	const unsigned int label_length = strlen(label);
	const unsigned int font_width = XSH_FONT_WIDTH(xsh);
	const unsigned int font_height = XSH_FONT_HEIGHT(xsh);

	XSH_SET_COLOR(dpy, gc, 0, 0, 0);
	XDrawString(xsh->gui.display, button->window, xsh->gui.gc,
		font_width, font_height-XSH_WIDGET_PADDING, 
		label, label_length);
#if 0
	{
		XWindowAttributes * geometry = &(button->geometry);

		XMoveResizeWindow(xsh->gui.display, button->window, 
			geometry->x, geometry->y,
			font_width*label_length, font_height+XSH_WIDGET_PADDING*2);
	}
	
{
			unsigned int width, height;
			GC gc = xsh->gui.gc;
			Pixmap pixmap;
			XReadBitmapFile(dpy, button->window,
				"bitmap.xbm", &width, &height,
				&pixmap, NULL, NULL);
			XSH_SET_COLOR(dpy, xsh->gui.gc, 255,255,255);
			XCopyPlane(dpy, pixmap, button->window,
				xsh->gui.gc, 0, 0, width, height, 0, 0, 1); 
			XFreePixmap(dpy, pixmap); 
}
#endif
}

static void
expose(XWidget * button)
{
#ifdef XSH_DECORATE
	if(button->events.button_press)
		xsh_decorate(button, XSH_DECOR_OUT);
	else
		xsh_decorate(button, XSH_DECOR_FLAT);
#endif /* XSH_DECORATE */
	draw_label((XShell *)(button->xsh), button);
}

static void
xshell_system(const char * command)
{
	if(!strcmp(command, "Exit___"))
		exit(0);
	else
		system(command);
}

static void
button_press(XWidget * button)
{
	XSHButtonData * data;

	XMSG("PRESSED");
	data=(XSHButtonData *)button->data;
#ifdef XSH_DECORATE
	xsh_decorate(button, XSH_DECOR_IN);
#endif /* XSH_DECORATE */
	draw_label((XShell *)(button->xsh), button);
	xshell_system(data->command);
}

static void
button_release(XWidget * button)
{
	expose(button);
}

static void
configure(XWidget * button)
{
	expose(button);
}


static void
setup_button_events(XWidget * button)
{
	button->events.expose=&expose;
	button->events.configure=&configure;
	button->events.key_press=NULL;
	button->events.button_press=&button_press;
	button->events.button_release=&button_release;
}

/* The result must be freed.  */
static char *
setup_label(const char * command)
{
	char * label;

	label=strdup(command);
	/* Start label after comment character, if any.  */
	label=strchr(label, '#')?label+1:(char*)label;
	{
		/* Replace underscore characters in label with spaces.  */
		char * iter=label;
		while((iter=strchr(iter, '_')))
			iter[0]=' ';
	}

	return label;
}

void
xshell_floating_button_new(XShell * xsh, XWidget * parent, 
	const char * command, int x, int y, 
	unsigned int width, unsigned int height)
{
	XWidget * button;
	XSHButtonData * data;
	char * label;

	xshell_XWidget_new(xsh, parent, x, y, width, height);
	button=xsh->gui.last_widget;
	button->data=data=malloc(sizeof(XSHButtonData));
	data->label=setup_label(data->command=(char *)command);
	setup_button_events(button);
}

void
xshell_button_new(XShell * xsh, XWidget * parent, const char * command)
{
	XShellGUILayout *layout=&(xsh->gui.layout);

	xshell_floating_button_new(xsh, parent, command,
		XSH_WIDGET_WIDTH*layout->column_count, 
		XSH_WIDGET_HEIGHT*layout->row_count,
		XSH_WIDGET_WIDTH, XSH_WIDGET_HEIGHT);
	if(++(layout->row_count) > layout->max_row_count)
	{
		layout->column_count++; 
		layout->row_count=0;
	}
}

