/*
  AntiRight
  (c) 2002-2007 Jeffrey Bedard
  antiright@gmail.com

  This file is part of AntiRight.

  AntiRight is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  AntiRight is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with AntiRight; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/


#include "xshell.h"

static void
setup_xshell_gui_layout(XShell * xsh, XShellGUILayout * layout)
{
	layout->row_count=0;
	layout->column_count=0;
	layout->max_row_count=XSH_ROWS_PER_COLUMN;
	layout->widget_width=XSH_WIDGET_WIDTH;
}

static void
setup_xshell_gui(XShell * xsh, XShellGUI * gui)
{
	gui->widgets=NULL;
	gui->widget_count=0;
	setup_xshell_gui_layout(xsh, &(gui->layout));
}

static void
setup_xshell(XShell * xsh)
{
	xsh->options=0;
	setup_xshell_gui(xsh, &(xsh->gui));
}

static void
delete_widgets(XWidget * head)
{
	XWidget * iter;

	iter=head;
	while(iter)
	{
		XWidget * next;

		next=iter->next;
		free(iter);
		iter=next;
	}
}

static void
cleanup(XShell * xsh)
{
	Display * dpy;

	dpy=xsh->gui.display;
	delete_widgets(xsh->gui.widgets);
	xsh_free_font(xsh);
	XFreeGC(dpy, xsh->gui.gc);
	XCloseDisplay(dpy);
}

static void
show_main_window(XShell * xsh)
{
	XShellGUI * gui = &(xsh->gui);
	Window toplevel=gui->widgets->window;
	Display * dpy = gui->display;

	toplevel=xsh->gui.widgets->window;
	XMapSubwindows(dpy, toplevel);
	XMapWindow(dpy, toplevel);
}

static void
setup_main_window(XShell * xsh)
{
	XShellGUI * gui = &(xsh->gui);

	/* Main window.  */
	xshell_XWidget_new(xsh, NULL, 0, 0, 100, 16);
	gui->gc=XSH_SETUP_GC(gui->display, gui->widgets->window);
	XSH_SET_COLOR(gui->display, gui->gc, 0xae, 0xb2, 0xc3);
	xsh_set_font(xsh, "-misc-fixed-medium-r-*-*-14-*-*-*-*-*-*-*");
}

static void
apply_toplevel_geometry(XShell * xsh)
{
	XMoveWindow(xsh->gui.display, xsh->gui.widgets->window,
		xsh->gui.widgets->geometry.x,
		xsh->gui.widgets->geometry.y);
}

int
main(int argc, char ** argv)
{
	XShell xsh;

	if(argc<=1)
		xsh_show_usage_and_exit();
	setup_xshell(&xsh);
	xsh.gui.display=XOpenDisplay(NULL);
	setup_main_window(&xsh);
#ifdef XSH_USE_GRADIENT
	xsh_setup_gradients(&xsh);
#endif /* XSH_USE_GRADIENT */
	xsh_parse_arguments(&xsh, argc, argv);
	show_main_window(&xsh);
	xsh_layout_widgets(&xsh);
	apply_toplevel_geometry(&xsh);
	xsh_event_loop(&xsh);
	cleanup(&xsh);

	return 0; 
}


