/*apolos.c
*
*    Copyright 2002 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://apolos.sourceforge.net
*
*	This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include<stdlib.h>
#include<gtk/gtk.h>

#include<stdio.h>
#include<unistd.h>
#include<getopt.h>

#include"../config.h"

#include"graf.h"
#include"sound.h"
#include"utils.h"
#include"conf.h"
#include"vol.h"
#include"callbacks.h"

#ifndef PLATFORM
#define PLATFORM "GNU/Linux"
#endif
#ifndef DEVELOPER
#define DEVELOPER1 "Jonathan Gonzalez V.<zeus@jonathan.cl>"
#define DEVELOPER2 "Davidlohr Bueso A. <dbueso@linuxchile.cl>"
#endif

int pepe (gpointer data);
int print_help (void);

static struct option options[] = {
  {"version", no_argument, NULL, 'v'},
  {"help", no_argument, NULL, 'h'}
};

int print_help (void)
{
  printf (_("Apolos v%s. Licensed under GPL.\n"), VERSION);
  printf (_("Options:\n"));
  printf (_("--version \t\t Show version and developers information\n"));
  printf (_("--help    \t\t Show this help message and exit\n"));
  printf (_("\nReport bugs to <zeus@emacs.cl>\n"));
	
	return 0;
}

int version() {
	printf(_("Apolos version %s for %s\n"), VERSION, PLATFORM);
	printf(_("is brought to you by %s and %s\n"), DEVELOPER1, DEVELOPER2);
	return 0;
}
int
main (int argc, char **argv)
{
  int chr;
  GtkWidget *hbox;

  Graf *graf;
  Datos *cd; // = (Datos *) malloc (sizeof (Datos));
  Vols *vols; // = (Vols *) malloc (sizeof (Vols));
  DatosCD *datos; // = (DatosCD *) malloc (sizeof (DatosCD));
  Rip *rip;

  while ( (chr = getopt_long (argc, argv, "v", options, NULL)) != -1)
    {
      switch (chr)
	{
	case 'v':
	  version();
	  exit (EXIT_SUCCESS);
	  break;
	case 'h':
	  print_help ();
	  exit (EXIT_SUCCESS);
	  break;
	default:
	  print_help ();
	  exit (EXIT_SUCCESS);
	  break;
	}
    }

  /* We have to change the argument 2 */  
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  graf = (Graf *) malloc (sizeof (Graf));
  cd = (Datos *) malloc (sizeof (Datos));
  vols = (Vols *) malloc (sizeof (Vols));
  datos = (DatosCD *) malloc (sizeof (DatosCD));
  rip = (Rip *) malloc (sizeof (Rip));
  
  rip->temp_files = (char *) calloc (35, sizeof (char *));
  rip->ripped_files = (char *) calloc (35, sizeof (char *));

  datos->graf = graf;
  datos->cd = cd;
  datos->vols = vols;
  datos->rip = rip;

  cd->cd_device = (char *) calloc (50, sizeof (char *));
  cd->barra = FALSE;
  cd->cddb = (CDDB *) malloc (sizeof (CDDB));

  cd->cddb->Servers = (Server *) malloc (sizeof (Server));
  cd->cddb->header = cd->cddb->Servers;

  rip->ripping = FALSE;
  rip->encoding = FALSE;

  /* We read the config file */
  config_file (cd, rip);

  /* Assign the memory the vols type */
  Assign_Memory (vols);

  /* Get the volume of Vol and CDROM */
  Get_Volume (vols);

  cd->fd = -1; /* Default value it's -1 it mean there's no cd */
  cd->existcd = FALSE; /* there's no cd */
  cd->checkin_disc = FALSE;

  rip->rip_mode = FALSE; /* We start without rip mode. */

  gtk_init (&argc, &argv);

  graf->win = ventana_principal (datos);

  graf->main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (graf->win), graf->main_vbox);
  gtk_widget_set_size_request (GTK_WIDGET (graf->main_vbox), 310, 165);

  graf->menu = menu (datos);

  gtk_box_pack_start (GTK_BOX (graf->main_vbox), graf->menu, FALSE, FALSE, 2);
  gtk_widget_show (graf->menu);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (graf->main_vbox), hbox, TRUE, TRUE, 0);

  graf->vbox = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), graf->vbox, TRUE, TRUE, 0);
  gtk_widget_show (graf->vbox);
  //  gtk_widget_set_size_request (GTK_WIDGET (graf->vbox), 200, 100);

  graf->statusbar = gtk_statusbar_new ();
  gtk_widget_set_size_request(graf->statusbar, 272, 20);
  gtk_box_pack_end (GTK_BOX (graf->main_vbox), graf->statusbar, FALSE, FALSE, 0);
  gtk_widget_show (graf->statusbar);

  graf->context_id =  gtk_statusbar_get_context_id (GTK_STATUSBAR (graf->statusbar), _("Status bar"));

  //  MSG_to_Statusbar(graf, _("Done."));

  graf->hbox2 = gtk_hbox_new (FALSE, 2);
  gtk_box_pack_start (GTK_BOX (graf->vbox), graf->hbox2, FALSE, FALSE, 0);
  gtk_widget_show (graf->hbox2);

  graf->table = gtk_table_new (2, 2, TRUE);
  gtk_box_pack_start (GTK_BOX (graf->hbox2), graf->table, TRUE, TRUE, 2);
  gtk_widget_show (graf->table);

  graf->hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_size_request (graf->hbox, -1, 30);
  gtk_box_pack_start (GTK_BOX (graf->vbox), graf->hbox, TRUE, TRUE, 0);
  gtk_widget_show (graf->hbox);

  graf->hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_set_size_request (graf->hbox3, 240, 30);
  gtk_box_pack_end (GTK_BOX (graf->vbox), graf->hbox3, TRUE, TRUE, 0);
  gtk_widget_show (graf->hbox3);

  botones (datos);
 
  dibujar_time (datos);

  graf->vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), graf->vbox2, TRUE, TRUE, 0);
  gtk_widget_show (graf->vbox2);

  Controles (datos);

  //  Check_Disc (NULL, (void *)datos);
  thread_check_disc (NULL, (void *)datos);

  gtk_widget_show (hbox);
  gtk_widget_show (graf->main_vbox);
  gtk_widget_show (graf->win);

  /* We update every 1 sec all strings */
  gtk_timeout_add (1000, pepe, datos);

  /* We update every 200 ms the scrolls */
  gtk_timeout_add (200, anime, datos);

  /* We update the bars of volume */
  gtk_timeout_add (100, sound_update, datos);

  gtk_main ();

  return 0;
}

int
pepe (gpointer data)
{
  DatosCD *datos;
  datos = (DatosCD *) data;
  update (datos);

  return TRUE;
}
