/*callbacks.h
*
*    Copyright 2003 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://apolos.sourceforge.net
*
*	This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _CALLBACKS_H

#define _CALLBACKS_H

/*
 * All functions moved here, are considered like a callback
 */

void Change_Volume (GtkAdjustment *adj, void * data);

void select_server (GtkTreeSelection * selection, gpointer data);

void Look_Up_Servers (GtkWidget * widget, gpointer data);

void Cerrar (GtkWidget * widget, gpointer data);

void select_row (GtkWidget *widget, GdkEventButton *event, void *data);

void destruir_winlist (GtkWidget * widget, gpointer data);

void Barajado (GtkWidget * widget, gpointer data);

void Repeat (GtkWidget * widget, gpointer data);

void Close_Main_Win (GtkWidget * widget, gpointer data);

void quit (gpointer data, unsigned int action, GtkWidget * widget);

/* The fallowing functions are callbacks of the sound.c file */

void play_cd (GtkWidget *widget, gpointer data);

void stop_cd (GtkWidget *widget, gpointer data);

void next_track (GtkWidget *widget, gpointer data);

void back_track (GtkWidget *widget, gpointer data);

void eject_cd (GtkWidget *widget, gpointer data);

void pause_track (GtkWidget *widget, gpointer data);

/* These callbacks operates in the menu */

void menu_play (gpointer data, unsigned int action, GtkWidget * widget);

void menu_stop (gpointer data, unsigned int action, GtkWidget * widget);

void menu_back (gpointer data, unsigned int action, GtkWidget * widget);

void menu_next (gpointer data, unsigned int action, GtkWidget * widget);

void menu_pause (gpointer data, unsigned int action, GtkWidget * widget);

void menu_eject (gpointer data, unsigned int action, GtkWidget * widget);

void menu_Check (gpointer data, unsigned int action, GtkWidget *widget);

void menu_CDDB (gpointer data, unsigned int action, GtkWidget * widget);

void Change_check_button (GtkWidget *widget, gpointer data);

/* This is the callback to play from X secs of the track */
void play_from (GtkAdjustment *adj, gpointer data);

void thread_check_disc (GtkWidget *widget, gpointer data);

/* Only one function works much better */
void play_toggled (GtkCellRendererToggle *toggle, char *path_str, gpointer data);

/* We now if the track must be ripped */
void rip_toggled  (GtkCellRendererToggle *toggle, char *path_str, gpointer data);

void start_rip (gpointer data, unsigned int action, GtkWidget * widget);

/* The callback to update the mixer */
int sound_update (gpointer data);

/* To play a track when the user made double click over the track in the playlist */
void play_track_from_playlist (GtkTreeView *treeview, GtkTreePath *path, GtkTreeViewColumn *arg2, gpointer data);

#endif
