#acinclude.m4
#
#    Copyright (C) 2004 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
#
#    http://www.nongnu.org/apolos
#
#    This file is part of apolos.
#
#    Apolos is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#AM_CHECK_GTK
# We need GTK+ >=2.0

AC_DEFUN([AM_CHECK_GTK],[

	AC_SUBST(GTK_LIBS)
	AC_SUBST(GTK_FLAGS)

	AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
	if test "$PKG_CONFIG" = "no"; then
		AC_MSG_ERROR(Debes tener instalado pkg-config)
	else
		AC_MSG_CHECKING( for GTK+ version >= 2.0)

		if $PKG_CONFIG --print-errors --exists gtk+-2.0; then
			GTK_LIBS=`$PKG_CONFIG gtk+-2.0 --libs`
			GTK_FLAGS=`$PKG_CONFIG gtk+-2.0 --cflags`
			LIBS="$GTK_LIBS"
			CFLAGS="$CFLAGS $GTK_FLAGS"
			AC_MSG_RESULT(yes)
		else
			AC_MSG_ERROR(No tienes GTK+ version 2.0)
		fi
	fi
])

# AM_CHECK_PTHREAD
 

AC_DEFUN([AM_CHECK_PTHREAD],[
	
	AC_SUBST(PTHREAD_LIBS)
	
	AC_CHECK_LIB(pthread, pthread_create, PTHREAD_LIBS="-lpthread")
])