/*cddb.h
*
*    Copyright (C) 2003 Jonathan Gonzalez V. <jonathan@blueplanet.cl>
*
*    http://www.nongnu.org/apolos
*
*    This file is part of apolos.
*
*    Apolos is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include"types.h"

#ifndef _CDDB_H

#define _CDDB_H


#define EXACT_MATCH 0
#define INEXACT_MATCH 1

typedef struct _errors
{
  int number;
  char desc[256];
  char accion[10];
  int marker;
  int Ok;
}
Errors;

unsigned int DiscID (Datos * cd);

int Suma (int n);

int Connection (CDDB * cddb);

void Recivir_Inicial (CDDB * cddb);

void Look_Up_CDDB (GtkWidget * widget, gpointer data);

void * Check_CDDB (void *data);

int Find (char *accion, int codigo, Graf *graf);

int Send_Request (CDDB * cddb, char *datos);

int Sign_on (CDDB * cddb);

int Query (DatosCD * datos);

void Make_Disc (DatosCD * datos, int codigo, char buf[]);

int Read (Datos * cd);

int Write_File (Datos * cd);

void Read_File (DatosCD * datos, char *file);

void Make_Titles (DatosCD * datos);

void * Servers (void * data);

int Servers_Request (CDDB * cddb);

#endif
