<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** Included file for get action service */
require_once(dirname(__FILE__) . "/../env.php");
require_once(dirname(__FILE__) . "/AService.php");
require_once($_MODELS_DIR . "/ApplicationDescriptor.php");

class GetService extends AService {

	public function __construct() {
		$this->name = "get";
	}

	public function run() {
		global $server, $header, $response, $input;
		// Check and get app id
		if (!isset($input['id']) || $input['id'] == "") {
			$this->reportBadRequest("Missing id parameter");
			return;
		}
		$appId = $input['id'];
		// Check version
		if (!isset($input['version']) || $input['version'] == "") {
			$this->reportBadRequest("Missing version parameter");
			return;
		}
		$versionCode = $input['version'];
		// Get data service
		$dataGetter = $server->getDataModule();
		if ($dataGetter === NULL) {
			$this->reportInternalError("Unable to get data service",
					NULL);
			return;
		}
		if (isset($input['data'])) {
			switch ($input['data']) {
			case "icon":
				$data = $dataGetter->getIcon($appId);
				break;
			default:
				$data = $dataGetter->getApplication($appId, $versionCode);
			}
		} else {
			$data = $dataGetter->getApplication($appId, $versionCode);
		}
		$response = $data;
		$header = "HTTP/1.0 200 Ok; Content-Type: application/octet-stream;"
				. " Content-Length: " . count($data);
	}

}

$get_service = new GetService();
$get_service->run();
?>
