<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** An application descriptor. This doesn't contains the application itself
 * but anything that could be required to run the server.
 */
class ApplicationDescriptor {

	private $identifier;
	private $sName;
	private $sDescription;
	private $sWebsite;
	private $aBranches;

	/** Contruct a new application descriptor.
	 * @param undefined $identifier The application unique identifier.
	 * Type is left to server implementation.
	 * @param String $sName Human readable application name.
	 * @param String $sDescription Human readable application description.
	 * @param String $sWebsite Application website.
	 * Nullable.
	 */
	public function __construct($identifier, $sName, $sDescription, $sWebsite,
			$aBranches) {
		$this->identifier = $identifier;
		if ($sName === NULL) {
			$this->sName = "";
		} else {
			$this->sName = $sName;
		}
		if ($sDescription === NULL) {
			$this->sDescription = "";
		} else {
			$this->sDescription = $sDescription;
		}
		$this->sWebsite = $sWebsite;
		if ($aBranches === NULL) {
			$this->aBranches = array();
		} else {
			$this->aBranches = $aBranches;
		}
	}

	/** Get application identifier
	 * @return undefined Application unique identifier. Type is left
	 * to server implementation.
	 */
	public function getIdentifier() {
		return $this->identifier;
	}

	/** Get application name. Name is never NULL.
	 * @return String Application name. Can be empty string but not NULL
	 */
	public function getName() {
		return $this->sName;
	}

	/** Get application description.
	 * @return String Application description. Can be empty string but not NULL
	 */
	public function getDescription() {
		return $this->sDescription;
	}

	/** Get application website url.
	 * @return String Application website url.
	 */
	public function getWebsite() {
		return $this->sWebsite;
	}

	/** Get branches.
	 * @return array Array of Branch.
	 */
	public function getBranches() {
		return $this->aBranches;
	}
}
?>
