<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** A branch is a group of versions that can update from one to another. */
class Branch {

	private $iIdentifier;
	private $sName;
	private $aVersions;
	
	public function __construct($iIdentifier, $sName, $aVersions) {
		$this->iIdentifier = $iIdentifier;
		$this->sName = $sName;
		$this->aVersions = $aVersions;
	}
	
	public function getIdentifier() {
		return $this->iIdentifier;
	}
	
	public function getName() {
		return $this->sName;
	}
	
	public function getVersions() {
		return $this->aVersions;
	}

	/** Get the latest version in the branch
	 * @return The latest Version as designed by the version code.
	 */
	public function getLatestVersion() {
		$versions = $this->getVersions();
		$latestVersion = NULL;
		foreach ($versions as $version) {
			if ($latestVersion == NULL
					|| $version->getCode() > $latestVersion->getCode()) {
				$latestVersion = $version;
			}
		}
		return $latestVersion;
	}
}

?>
