<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

require_once(dirname(__FILE__) . "/../../env.php");
require_once($_MODELS_DIR . "/Category.php");
require_once(dirname(__FILE__) . "/ApplicationDescriptorJSONDTO.php");

class CategoryJSONDTO {

	private function __construct() {
		
	}

	public static function toJSON($category, $iAppDescMask) {
		// Need to do it manually to include
		// children applications descriptor filtering.
		// Translate category attributes
		$json = '{"id":' . $category->getIdentifier() . ',';
		$name = json_encode(utf8_encode($category->getName()));
		$json .= '"name":' . $name . ',';
		$json .= '"subcategories":';
		// Translate subcategories
		$aSubcategories = $category->getSubcategories();
		if ($aSubcategories !== NULL) {
			$bFirstElement = true;
			$json .= '[';
			foreach ($aSubcategories as $subcategory) {
				if ($bFirstElement) {
					$bFirstElement = false;
				} else {
					$json .= ",";
				}
				$json .= CategoryJSONDTO::toJSON($subcategory, $iAppDescMask);
			}
			$json .= ']';
		} else {
			$json .= 'null';
		}
		// Translate applications
		$json .= ',"applications":';
		$aApplications = $category->getApplications();
		if ($aApplications !== NULL) {
			$bFirstElement = true;
			$json .= '[';
			foreach ($category->getApplications() as $application) {
				if ($bFirstElement) {
					$bFirstElement = false;
				} else {
					$json .= ",";
				}
				$json .= ApplicationDescriptorJSONDTO::toJSON(
						$application, $iAppDescMask);
			}
			$json .= ']';
		} else {
			$json .= 'null';
		}
		$json .= '}';
		return $json;
	}
}

?>
