//
//    cctools --- tools for the C++ programmer
//    Copyright (C) 2000 Jan Pfeifer 
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Lesser General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public
//    License along with this library; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
//


#include <exception>
#include <stdexcept>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/poll.h>
#include <time.h>
#include <csignal>
#include <cerrno>
#include <cstring>
#include <cstdlib>
#include <cstdio>
#include <cctype>

#include <fstream>
#include <iostream>
#include <string>

//#include "cctools-rcptr.hh"
//#include "cctools-exception.hh"
//#include "cctools-time.hh"
//#include "cctools-string.hh"
//#include "cctools-file.hh"
//#ifdef PTHREADS
//#include "cctools-pthread.hh"
//#endif
//#ifdef SOCKETS
//#include "cctools-socket.hh"
//#endif



using namespace std;

const size_t BUFFER_SIZE = 32768;

namespace cctools {

// cctools.hh
//============================================================

//------------------------------------------ Execute shell command
//  like system from stdlib, but tests for exec errors and
//   throws exceptions
int system(const string &cmd) throw (std::runtime_error);


/**
 * Run command and return its output
 * 
 * @param cmd command to run
 * @returns string evaluated
 **/
int system( const std::string &cmd, 
		const std::string &input, 
		std::string &output,
		std::string &error,
		unsigned timeout ) throw ( std::bad_alloc, std::runtime_error );

}
//============================================================
// cctools.hh
