/*
 * bdata.h
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef BDATA_H
#define BDATA_H

#include <iostream>
#include <string>

#include <boost/shared_ptr.hpp>
#include <boost/filesystem/path.hpp>

#include "utils.h"

/**
 * Representation of arbitrary binary data.
 *
 * This class encapsulates a series of bytes.
 *
 * FIXME: missing:
 * - Read/write from/to files and streams
 * - Initialize from char*, int
 */
class bdata {
private:
	char * data;
	size_t size;
public:
	bdata (const char * d, const size_t s);
	bdata (Path& path);
	bdata (std::istream& in);
	bdata (std::string& s);
	bdata (const bdata& d);
	bdata ();

	~bdata();

	void set_data(const char * c, const size_t size);
	
	void add(const char *c, const size_t size);
	
	void add(bdata& d);

	size_t get_size() const;
	char * get_data() const;
	std::string get_string() const;


	void read(std::istream& in);
	void save(std::ostream& out) const;
	void read(Path& path);
	void save(Path& path) const;

	void operator= (const bdata& b);
};

typedef boost::shared_ptr<bdata> bdata_ptr;

#endif

