#!/bin/sh

error () {
	echo "Apso could not be compiled. The step that resulted in error was: ";
	echo $1;
	exit -1;
}

autoheader
if [ $? -ne 0 ]; then
	error "autoheader"
fi

libtoolize --force
if [ $? -ne 0 ]; then
	error "libtoolize"
fi

aclocal-1.9
if [ $? -ne 0 ]; then
	error "aclocal"
fi

automake-1.9 -a
if [ $? -ne 0 ]; then
	error "automake"
fi

autoconf
if [ $? -ne 0 ]; then
	error "autoconf"
fi

./configure
if [ $? -ne 0 ]; then
	error "configure"
fi

make
if [ $? -ne 0 ]; then
	error "make"
fi

echo "Apso was compiled successfully. Now you can run 'make install' to install it in /usr/local/"

