/*
 * options.h
 *
 * Copyright (C) 2006 Jernimo Pellegrini
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *   The Free Software Foundation, Inc.,
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef OPTIONS_H
#define OPTIONS_H

#include <string>
#include <boost/filesystem/path.hpp>
#include <boost/shared_ptr.hpp>

#include "utils.h"

namespace apso {

/**
 * Represents command-line options passed to Apso.
 *
 *
 */
class Options {
private:
	std::string vc_system;
	Path apso_priv_key;
	std::string vc_priv_key;
	std::string user_id; // of the user being granted/revoked
	Path user_pubk; // of the user being granted/revoked
	std::string branch;
	Path pubrep;
	Path privrep;
	Path scratch;
public:
	void set_vc_system(std::string vc);
	void set_vc_prk(const std::string& key);
	void set_apso_prk(const Path& key);
	void set_branch(std::string branch);
	void set_pubrep(std::string pr);
	void set_privrep(std::string pr);
	void set_scratch(std::string sc);

	std::string get_vc_system();
	Path get_apso_prk();
	std::string get_vc_prk();
	std::string get_branch();
	std::string get_user_id();
	void set_user_id (const std::string& userid);
	void set_user_pubk(const std::string& userkey);
	Path get_user_pubk();
	Path get_pubrep();
	Path get_privrep();
	Path get_scratch();
};

typedef boost::shared_ptr<Options> Options_ptr;

}

#endif
