/*  Begin file_phillips.cpp  */

/*  "class File" for Phillips spectrum  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "file_phillips.h"

#include "file.h"


/****************  namespaces  ****************/


using namespace std;


/****************  public functions  ****************/


File_Phillips::File_Phillips(char *input_file, char *output_file)
  throw(const char *)
  : File(input_file, output_file),
    String_spectrum_factor("spectrum_factor"),
    String_smallest_wave("smallest_wave"),
    String_wind_speed("wind_speed"),
    String_wind_angle("wind_angle")
{
}


/****  read  ****/

/*  reads "Input_file" and initializes variables  */
void
File_Phillips::read_configure(void) throw(const char *)
{
  string temp;

  this->File::read_configure();

  *this->Input_stream >> temp >> this->spectrum_factor
		      >> temp >> this->smallest_wave
		      >> temp >> this->wind_speed
		      >> temp >> this->wind_angle
    ;

  this->check_stream(this->Input_stream,
		     this->Error_message_read,
		     this->Input_file);
}


/*  reads "Input_file" and initializes variables  */
void
File_Phillips::read_header(void) throw(const char *)
{
  this->File::read_header();

  *this->Input_stream >> this->spectrum_factor
		      >> this->smallest_wave
		      >> this->wind_speed
		      >> this->wind_angle
    ;

  this->check_stream(this->Input_stream,
		     this->Error_message_read,
		     this->Input_file);
}


/****  write  ****/

/*  writes template file (i.e. variables strings) into "Output_file"  */
void
File_Phillips::write_configure_template(void) const throw(const char *)
{
  this->File::write_configure_template();

  *this->Output_stream << this->String_spectrum_factor << this->String_end
		       << this->String_smallest_wave << this->String_end
		       << this->String_wind_speed << this->String_end
		       << this->String_wind_angle << this->String_end
		       << flush
    ;

  this->check_stream(this->Output_stream,
		     this->Error_message_write,
		     this->Output_file);
}


/*  writes header into "Output_file"  */
void
File_Phillips::write_header(void) const throw(const char *)
{
  this->File::write_header();

  *this->Output_stream << this->spectrum_factor << " "
		       << this->smallest_wave << " "
		       << this->wind_speed << " "
		       << this->wind_angle << " "
		       << flush
    ;

  this->check_stream(this->Output_stream,
		     this->Error_message_write,
		     this->Output_file);
}


/*  End file_phillips.cpp  */
