/*  Begin surface.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "surface.h"

#include "file.h"

/*  libaqua  */
#include "src/aqua_surface.h"

/*  C++ lib  */
#include <iostream>


/****************  namespaces  ****************/


using namespace std;


/****************  public functions  ****************/


Surface::Surface(bool is_verbose) throw(const char *)
  : Is_verbose(is_verbose)
{
  /*  start message for initialization (see "init()")  */
  if (is_verbose)
    {
      cout << "Initializing..." << flush;
    }
}


/*  virtual destructor  */
Surface::~Surface(void)
{
}


void
Surface::compute_and_write(void) const throw(const char *)
{
  float ***temp;
  float time;

  int i;


  this->file->write_header();

  if (this->Is_verbose)
    {
      cout << "Computing frame";
    }
  for (i = 0; i < this->frames_number; i++)
    {
      if (this->Is_verbose)
	{
	  cout << " " << i + 1 << flush;
	}

      time = i * this->frame_length;
      this->surface->set_time(time);

      /*  surface  */
      temp = this->surface->get_surface();
      this->file->write(temp);
      /*  normal  */
      temp = this->surface->get_normals();
      this->file->write(temp);
    }
  if (this->Is_verbose)
    {
      cout << "\n"
	   << "Done."
	   << endl
	;
    }
}


/****************  protected functions  ****************/


/*  should be called in inherited classes constructor  */
void
Surface::init(class File *file)
{
  /*  end message for initialization (see constructor)  */
  if (this->Is_verbose)
    {
      cout << " done." << endl;
    }

  this->frame_length = this->get_frame_length(file->frames_per_second);
  this->frames_number = this->get_frames_number(file->loop_time,
						file->frames_per_second);

  if (this->Is_verbose)
    {
      cout << "Number of frames to compute: " << this->frames_number << endl;
    }
}


/****  get  ****/

float
Surface::get_frame_length(int frames_per_second) const
{
  return 1.0 / frames_per_second;
}


int
Surface::get_frames_number(int loop_time, int frames_per_second) const
{
  return loop_time * frames_per_second;
}


/*  End surface.cpp  */
