/*  Begin fps.cpp  */

/*  frames per second  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "fps.h"

/*  C++ lib  */
#include <sstream>
#include <string>

/*  C lib  */
extern "C"
{
#include <math.h>
}


/****************  namespaces  ****************/


using namespace std;


/****************  public functions  ****************/


/*
  Creates and inits a FPS counter.
  Average FPS will be computed every "number_of_frames_max" frames.
*/
Fps::Fps(int number_of_frames_max, float current_time)
  : number_of_frames_max(number_of_frames_max)
{
  this->reset(current_time);
  this->time_average = 0.0;
  this->time_average_lib = 0.0;
}


/*  virtual destructor  */
Fps::~Fps(void)
{
}


/****  set  ****/

/*
  To be called each frame.
  "elapsed_time_lib" is the time taken by the library during the curent frame.
*/
void
Fps::set_elapsed_time(float current_time, float elapsed_time_lib)
{
  this->current_frame++;

  /*  store elapsed time between several calls  */
  this->time_total += current_time - this->current_time;
  this->current_time = current_time;
  this->time_total_lib += elapsed_time_lib;

  if (this->current_frame >= number_of_frames_max)
    {
      this->time_average = this->time_total / this->number_of_frames_max;
      this->time_average_lib =
	this->time_total_lib / this->number_of_frames_max;
      this->reset(current_time);
    }
}


/*  re-inits Fps  */
void
Fps::reset(float current_time)
{
  this->current_frame = 0;
  this->current_time = current_time;
  this->time_total = 0.0;
  this->time_total_lib = 0.0;
}


/****  get  ****/

void
Fps::get_string(string *str) const
{
  ostringstream temp_stream;

  temp_stream << rintf(1000.0 / this->time_average)  << " FPS "
	        << "(total: " << rintf(this->time_average) << " ms, "
	        << "lib: " << rintf(this->time_average_lib) << " ms)\n"
    ;

  *str = temp_stream.str();
}


/*  End fps.cpp  */
