/*  Emacs mode:  -*- C++ -*-  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef HELP_H
#define HELP_H


/****************  includes  ****************/


/*  C++ lib  */
#include <string>


/****************  namespaces  ****************/


using namespace std;


/****************  abstract classes  ****************/


class Help
{
 public:

  /*  general  */
  const char Key_help;
  const char Key_quit;
  const char Key_pause;
  const char Key_info;
  const char Key_fps;
  const char Key_stone;
  /*  camera  */
  const char Key_view;
  /*  surface look  */
  const char Key_wire;
  const char Key_normals;
  const char Key_tiled;
  const char Key_surface_alpha_decrease;
  const char Key_surface_alpha_increase;
  /*  surface physics  */
  const char Key_points_decrease;
  const char Key_points_increase;
  const char Key_points_x_decrease;
  const char Key_points_x_increase;
  const char Key_points_z_decrease;
  const char Key_points_z_increase;
  const char Key_size_decrease;
  const char Key_size_increase;
  const char Key_size_x_decrease;
  const char Key_size_x_increase;
  const char Key_size_z_decrease;
  const char Key_size_z_increase;
  const char Key_depth_decrease;
  const char Key_depth_increase;
  const char Key_displacement_factor_decrease;
  const char Key_displacement_factor_increase;


  Help(void);
  virtual ~Help(void) = 0;


  virtual const string *get_message(void) const;


 protected:

  const char * const Separator;
  string Message;


  string create_message(const char *separator);


  /*  copy constructor to be defined  */
  Help(const class Help &);
};


#endif  /*  HELP_H  */
