/*  Begin help_phillips.cpp  */

/*  help message for Phillips spectrum  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "help_phillips.h"

#include "help.h"

#include "config.h"

/*  C++ lib  */
#include <sstream>
#include <string>


/****************  namespaces  ****************/


using namespace std;


/****************  public functions  ****************/


Help_Phillips::Help_Phillips(void)
  : Key_spectrum_factor_decrease(Config_help_spectrum_factor_decrease),
    Key_spectrum_factor_increase(Config_help_spectrum_factor_increase),
    Key_smallest_wave_decrease(Config_help_smallest_wave_decrease),
    Key_smallest_wave_increase(Config_help_smallest_wave_increase),
    Key_wind_speed_decrease(Config_help_wind_speed_decrease),
    Key_wind_speed_increase(Config_help_wind_speed_increase),
    Key_wind_angle_decrease(Config_help_wind_angle_decrease),
    Key_wind_angle_increase(Config_help_wind_angle_increase)
{
  this->Help::Message += this->create_message(this->Help::Separator);
}


/****************  protected functions  ****************/


string
Help_Phillips::create_message(const char *separator)
{
  ostringstream temp_stream;

  temp_stream << "\n"
	      << "Phillips spectrum" << "\n"
	      << "  increase / decrease spectrum factor: "
	        << this->Key_spectrum_factor_increase
	        << separator << this->Key_spectrum_factor_decrease << "\n"
	      << "  increase / decrease smallest wave length: "
	        << this->Key_smallest_wave_increase
	        << separator << this->Key_smallest_wave_decrease << "\n"
	      << "  increase / decrease speed: "
	        << this->Key_wind_speed_increase
	        << separator << this->Key_wind_speed_decrease << "\n"
	      << "  increase / decrease angle: "
	        << this->Key_wind_angle_increase
	        << separator << this->Key_wind_angle_decrease << "\n"
    ;

  return temp_stream.str();
}


/*  End help_phillips.cpp  */
