/*  Begin main.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "callback.h"
#include "options_local.h"

/*  local lib  */
#include "lib/exceptions.h"

/*  graphic lib  */
extern "C"
{
#include <GL/glut.h>
}

/*  C++ lib  */
#include <exception>  /*  class exception  */
#include <new>        /*  class bad_alloc  */

/*  C lib  */
extern "C"
{
#include <stdlib.h>  /*  EXIT_SUCCESS  */
}


/****************  namespaces  ****************/


using namespace std;

 
/****************  functions  ****************/


int
main(int argc, char** argv)
{
  try
    {
      class Options_Arguments_Local *arguments =
	new class Options_Arguments_Local;
      class Options_Local *options = new class Options_Local(argc, argv);

      /*
	Size and position of the window by default.
	Set before calling glutInit to allow user to override them on command
	line.
      */
      glutInitWindowSize(800, 600);
      glutInitWindowPosition(20, 0);

      /*  glutInit must be call before command line arguments parsing  */
      glutInit(&argc, argv);
      options->parse(arguments);
  
      /*  creates window  */
      glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
      if (arguments->is_fullscreen)
	{
	  glutEnterGameMode();
	}
      else
	{
	  glutCreateWindow(options->Program_name);
	}

      /*  frees options and arguments  */
      delete options;
      delete arguments;


      /*  OpenGL callbacks function initialization  */
      callback_init();

      glutMainLoop();
    }
  catch(class bad_alloc &exception)
    {
      exceptions(argv[0], exception);
    }
  catch(class exception &exception)
    {
      exceptions(argv[0], exception);
    }


  /*  never reached  */
  return EXIT_SUCCESS;
}


/*  End main.cpp  */
