/*  Emacs mode: -*- C++ -*-  */

/*  "Scene" with "Aqua_Surface_Phill_Ugauss"  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef SCENE_PHILL_UGAUSS_H
#define SCENE_PHILL_UGAUSS_H


/****************  includes  ****************/


#include "scene.h"

/*  C++ lib  */
#include <string>


/****************  namespaces  ****************/


using namespace std;


/****************  inherited classes  ****************/


class Scene_Phill_Ugauss : public Scene
{
 public:

  Scene_Phill_Ugauss(int points_x_index,        /*  number of points...       */
		     int points_z_index,        /*  ...must be powers of two  */
		     int size_x_index,              /*  surface size, meters  */
		     int size_z_index,
		     int depth_index,             /*  depth of water, meters  */
		     int displacement_factor_index,  /*  horizontal  */
		     int spectrum_factor_index,
		     int smallest_wave_index, /* smallest wave length, meters */
		     int wind_speed_index,           /*  m.s-1  */
		     int wind_angle_index,           /*  radians  */
		     int surface_alpha_index, /* OpenGL alpha value (opacity) */
		     bool is_wired,              /*  is surface drawn wired?  */
		     bool is_normals_draw,           /*  are normals drawn?  */
		     bool is_tiled,                  /*  is surface tiled?  */
		     bool is_stone_draw);            /*  is stone drawn?  */
  virtual ~Scene_Phill_Ugauss(void);


  /****  set  ****/

  /*  spectrum_factor  */
  void spectrum_factor_decrease(void);
  void spectrum_factor_increase(void);
  /*  smallest_wave  */
  void smallest_wave_decrease(void);
  void smallest_wave_increase(void);
  /*  wind_speed  */
  void wind_speed_increase(void);
  void wind_speed_decrease(void);
  /*  wind_angle  */
  void wind_angle_increase(void);
  void wind_angle_decrease(void);


  /****  get  ****/

  float get_spectrum_factor(void) const;
  float get_smallest_wave(void) const;
  float get_wind_speed(void) const;
  float get_wind_angle(void) const;
  virtual void get_string(string *str) const;


 protected:

  /*  values arrays  */
  const float * const spectrum_factor_array;
  const float * const smallest_wave_array;
  const float * const wind_speed_array;
  const float * const wind_angle_array;
  
  /*  arrays sizes  */
  const int spectrum_factor_array_size;
  const int smallest_wave_array_size;
  const int wind_speed_array_size;
  const int wind_angle_array_size;

  /*  arrays indexes  */
  int spectrum_factor_index;
  int smallest_wave_index;
  int wind_speed_index;
  int wind_angle_index;

  class Aqua_Surface_Phill_Ugauss *surface;

  /****  global changes  ****/
  void global_change_spectrum_factor(bool is_spectrum_factor_changed,
				     float spectrum_factor,
				     class Aqua_Surface_Phill_Ugauss *surface,
				     bool is_wired,
				     bool is_normals_draw);
  void global_change_smallest_wave(bool is_smallest_wave_changed,
				   float smallest_wave,
				   class Aqua_Surface_Phill_Ugauss *surface,
				   bool is_wired,
				   bool is_normals_draw);
  void global_change_wind_speed(bool is_wind_speed_changed,
				float wind_speed,
				class Aqua_Surface_Phill_Ugauss *surface,
				bool is_wired,
				bool is_normals_draw);
  void global_change_wind_angle(bool is_wind_angle_changed,
				float wind_angle,
				class Aqua_Surface_Phill_Ugauss *surface,
				bool is_wired,
				bool is_normals_draw);

  virtual void surface_recreate(void);

  /*  copy constructor to be defined  */
  Scene_Phill_Ugauss(const class Scene &);
};


#endif  /*  SCENE_PHILL_UGAUSS_H  */
