/*  Emacs mode: -*- C++ -*-  */

/*  memory allocation and freeing  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef MEMORY_H
#define MEMORY_H


/****************  templates prototypes  ****************/


/****  allocation  ****/
template<typename T> T **memory_alloc_2d(int size_x, int size_y);
template<typename T> T ***memory_alloc_3d(int size_x, int size_y, int size_z);
/****  freeing  ****/
template<typename T> void memory_free_2d(int size_x, T **vector);
template<typename T> void memory_free_3d(int size_x, int size_y, T ***vector);


/****************  templates  ****************/


/****  allocation  ****/

template<typename T>
T **
memory_alloc_2d(int size_x, int size_y)
{
  T **temp;
  int i;

  temp = new T * [size_x];

  for (i = 0; i < size_x; i++)
    {
      temp[i] = new T[size_y];
    }

  return temp;
}


template<typename T>
T ***
memory_alloc_3d(int size_x, int size_y, int size_z)
{
  T ***temp;
  int i;

  temp = new T ** [size_x];
  for (i = 0; i < size_x; i++)
    {
      temp[i] = memory_alloc_2d<T>(size_y, size_z);
    }

  return temp;
}


/****  freeing  ****/

template<typename T>
void
memory_free_2d(int size_x, T **vector)
{
  int i;

  for (i = 0; i < size_x; i++)
    {
      delete[] vector[i];
    }

  delete[] vector;
}


template<typename T>
void
memory_free_3d(int size_x, int size_y, T ***vector)
{
  int i;

  for (i = 0; i < size_x; i++)
    {
      memory_free_2d(size_y, vector[i]);
    }

  delete[] vector;
}


#endif  /*  MEMORY_H  */
