/*  Begin options.cpp  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "options.h"

#include "get_file_name.h"

/*  C++ lib  */
#include <iostream>
#include <string>


/****************  namespaces  ****************/


using namespace std;

 
/*****************************************************/
/****************  Options_Arguments  ****************/
/*****************************************************/


/****************  public functions  ****************/


/*  virtual destructor  */
Options_Arguments::~Options_Arguments(void)
{
}


/*******************************************/
/****************  Options  ****************/
/*******************************************/


/****************  public functions  ****************/


Options::Options(int argc, char **argv)
  : Program_name(get_file_name(argv[0])),
    Argc(argc),
    argv(argv)
{
}


/*  virtual destructor  */
Options::~Options(void)
{
}


/****************  protected functions  ****************/


/****  display  ****/

void
Options::display_usage(bool is_error) const
{
  int exit_status;

  if (is_error)
    {
      cerr << this->usage;
      exit_status = EXIT_FAILURE;
    }
  else
    {
      cout << this->usage;
      exit_status = EXIT_SUCCESS;
    }

  exit(exit_status);
}


void
Options::
display_version(void) const
{
  cout << this->version;

  exit(EXIT_SUCCESS);
}


/*  End options.cpp  */
