/*  Emacs mode: -*- C++ -*-  */

/*  "Aqua_Wave" with Phillips spectrum  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _AQUA_WAVE_PHILLIPS_H
#define _AQUA_WAVE_PHILLIPS_H


/****************  includes  ****************/


#include "aqua_wave.h"


/****************  inherited classes  ****************/


class Aqua_Wave_Factory_Phillips : public Aqua_Wave_Factory
{
 public:

  virtual class Aqua_Wave *create(void);
};


class Aqua_Wave_Spectrum_Context_Phillips : public Aqua_Wave_Spectrum_Context
{
 public:

  float spectrum_factor;
  float smallest_wave;    /*  smallest wave length, meters  */

  Aqua_Wave_Spectrum_Context_Phillips(float spectrum_factor,
				      float smallest_wave,    /*  meters  */
				      float wind_speed,       /*  m.s-1  */
				      float wind_angle);      /*  radians  */


  /****  set  ****/

  /*  sets "wind_speed and "largest_wave"  */
  void set_wind_speed(float wind_speed);  /*  m.s-1  */
  /*  sets "wind_angle" and "wind_vector"  */
  void set_wind_angle(float wind_angle);  /*  radians  */


  /****  get  ****/

  float get_wind_speed(void) const;
  float get_largest_wave(void) const;
  float get_wind_angle(void) const;
  /*  fills two elements vector "wind_vector"  */
  void get_wind_vector(float *wind_vector) const;


 protected:

  float wind_speed;
  float largest_wave;     /*  meters  */
  float wind_angle;
  float wind_vector[2];   /*  (X, Z) component of the wind vector, normalized */
};


class Aqua_Wave_Phillips : public Aqua_Wave
{
 public:

  /*  inits the wave and sets magnitude_[xz] and unit_vector_[xz]  */
  virtual void init(float &magnitude_x,      /* vector magnitude */
		    float &magnitude_z,
		    float &unit_vector_x,    /* normalized vector magnitude */
		    float &unit_vector_z,
		    int vector_x,       /* vector X coordinate, [ -N/2, N/2 [ */
		    int vector_z,       /* vector Z coordinate, [ -M/2, M/2 [ */
		    float size_x,      /* size_x of the whole surface, meters */
		    float size_z,      /* size_z of the whole surface, meters */
		    float random_real,       /*  random number  */
		    float random_imaginary,  /*  random number  */
		    float depth,  /* water depth, meters (0.0 means infinite) */
		    float basic_frequency,   /*  s-1, 0.0 means no loop  */
		    class Aqua_Wave_Spectrum_Context *context_phillips);
  /*  context must be of type "Aqua_Wave_Spectrum_Context_Phillips"  */
  virtual float
  compute_spectrum(struct Aqua_Wave_Spectrum_Context *context_phillips);


 protected:

  /* normalized vector magnitude */
  float unit_vector[2];
};


#endif  /*  _AQUA_WAVE_PHILLIPS_H  */
