# variables definitions for all makefiles


################  user configuration  ################

# this configuration should suits for most GNU based system


## compilers

CXX = g++
CC  = gcc


## C and CXX FLAGS

CFLAGS   = -W -Wall -ansi -pedantic -pipe -O3
CXXFLAGS = $(CFLAGS)


## LDFLAGS

# GSL
GSL_LDFLAGS = -lgsl -lgslcblas -lm

# FFTW
FFTW_LDFLAGS = -lfftw3f -lm

# graphic libraries
X_LDFLAGS =  -L/usr/X11R6/lib -lglut -lGLU -lGL -lXmu -lXi -lX11 -lm 

# if you don't have glut, comment the next line
HAVE_GLUT = yes


################  end of user configuration  ################


# "TOP_DIR" must be define in all Makefiles, before including this file


## directories

LIB_DIR      = $(TOP_DIR)/lib
SRC_DIR      = $(TOP_DIR)/src
AQUA-GEN_DIR = $(TOP_DIR)/aqua-gen
DEMO_DIR     = $(TOP_DIR)/demo


## CPPFLAGS

CPPFLAGS = -I$(TOP_DIR)


# libaqua
LIBAQUA = $(SRC_DIR)/libaqua.so
