/*  Emacs mode: -*- c++ -*-  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef CONFIG_H
#define CONFIG_H


/****************  includes  ****************/


#include "camera.h"  /*  for "Config_camera_view_mode"  */

/*  local includes  */
#include "include/constant.h"  /*  for "Config_scene_wind_angle"  */

/*  graphic lib  */
extern "C"
{
#include <GL/gl.h>
}

/****************  constants  ****************/


/****  start-up values  ****/

/*  booleans  */
const bool  Config_is_pause                = false;
const bool  Config_is_string_fps_display   = false;
const bool  Config_is_string_help_display  = true;
const bool  Config_is_string_scene_display = false;

/*  scene  */
/*  "index" values are taken from "values arrays" bellow  */
/*  surface physical values  */
const int  Config_scene_points_x_index      = 2;      /*  128  */
const int  Config_scene_points_z_index      = 2;      /*  128  */
const int  Config_scene_size_x_index        = 2;      /*  100.0 m  */
const int  Config_scene_size_z_index        = 2;      /*  100.0 m  */
const int  Config_scene_depth_index         = 3;      /*  0.0 m  */
const int  Config_scene_displ_fact_index    = 2;      /*  1.0  */
const int  Config_scene_spect_fact_index    = 2;      /*  4e-6  */
const int  Config_scene_small_wave_index    = 2;      /*  0.1 m  */
const int  Config_scene_wind_speed_index    = 8;      /*  20.0 m.s-1   */
const int  Config_scene_wind_angle_index    = 1;      /*  pi / 2 rad  */
/*  drawing values  */
const int  Config_scene_surface_alpha_index = 10;     /*  1.0  */
const bool Config_scene_is_wired            = false;
const bool Config_scene_is_normals_draw     = false;
const bool Config_scene_is_tiled            = false;
const bool Config_scene_is_stone_draw       = true;

/*  sun  */
const float Config_sun_day_length  = 30.0;  /*  seconds  */
const float Config_sun_latitude    = 45.0;/*45 is Lacanau, France*//* degrees */
const float Config_sun_day_of_year = 0.0; /* [0,2pi[, rad, 0 is march equinox */

/*  camera  */
const camera_view_mode Config_camera_view_mode = Observing;

/*  FPS  */
/*  FPS are computed every "frames_max" frames  */
const int  Config_fps_frames_max = 10;

/*  gluPerspective parameters  */
/* 
   assumes that screen height is 25 cm and viewpoint is 50 cm from the screen
   (znear), so fovy is atan(screen_height / 2.0 / znear) * 2.0 ~= 28.0 degrees
*/
const float Config_gluperspective_fovy  = 28.0;    /*  degrees  */
const float Config_gluperspective_znear = 0.5;     /*  meters  */
const float Config_gluperspective_zfar  = 4000.0;  /*  meters  */

/*  GL hints  */
const GLenum Config_glhint_perspective = GL_DONT_CARE;
const GLenum Config_glhint_point       = GL_DONT_CARE;
const GLenum Config_glhint_line        = GL_DONT_CARE;
const GLenum Config_glhint_polygon     = GL_DONT_CARE;

/*  help keys  */
/*  general  */
const char Config_help_help                         = 'h';
const char Config_help_quit                         = 'q';
const char Config_help_pause                        = 'p';
const char Config_help_info                         = 'i';
const char Config_help_fps                          = 'f';
const char Config_help_stone                        = 'g';
/*  camera  */
const char Config_help_view                         = 'v';
/*  surface look  */
const char Config_help_wire                         = 'w';
const char Config_help_normals                      = 'n';
const char Config_help_tiled                        = 't';
const char Config_help_surface_alpha_decrease       = 'r';
const char Config_help_surface_alpha_increase       = 'R';
/*  surface physics  */
const char Config_help_points_decrease              = 'x';
const char Config_help_points_increase              = 'X';
const char Config_help_points_x_decrease            = 'y';
const char Config_help_points_x_increase            = 'Y';
const char Config_help_points_z_decrease            = 'u';
const char Config_help_points_z_increase            = 'U';
const char Config_help_size_decrease                = 's';
const char Config_help_size_increase                = 'S';
const char Config_help_size_x_decrease              = 'j';
const char Config_help_size_x_increase              = 'J';
const char Config_help_size_z_decrease              = 'k';
const char Config_help_size_z_increase              = 'K';
const char Config_help_depth_decrease               = 'd';
const char Config_help_depth_increase               = 'D';
const char Config_help_displacement_factor_decrease = 'l';
const char Config_help_displacement_factor_increase = 'L';
/*  Phillips spectrum  */
const char Config_help_spectrum_factor_decrease     = 'e';
const char Config_help_spectrum_factor_increase     = 'E';
const char Config_help_smallest_wave_decrease       = 'm';
const char Config_help_smallest_wave_increase       = 'M';
const char Config_help_wind_speed_decrease          = 'a';
const char Config_help_wind_speed_increase          = 'A';
const char Config_help_wind_angle_decrease          = 'b';
const char Config_help_wind_angle_increase          = 'B';
/*  separator  */
const char * const Config_help_separator            = " / ";


/****  scene values arrays  ****/

/*  points, must be powers of two  */
const int Config_scene_points_array_size = 5;
const int Config_scene_points_array[Config_scene_points_array_size] =
  { 32, 64, 128, 256, 512 };
/*  size, meters  */
const int Config_scene_size_array_size = 4;
const float Config_scene_size_array[Config_scene_size_array_size] =
  { 50.0, 100.0, 200.0, 400.0 };
/*  depth, meters, 0.0 means infinite  */
const int Config_scene_depth_array_size = 4;
const float Config_scene_depth_array[Config_scene_depth_array_size] =
  { 1.0, 5.0, 10.0, 0.0 };
/*  displacement_factor, horizontal, meters  */
const int Config_scene_displ_fact_array_size = 11;
const float Config_scene_displ_fact_array[Config_scene_displ_fact_array_size] =
  { 0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0 };
/*  spectrum_factor  */
const int Config_scene_spect_fact_array_size = 6;
const float Config_scene_spect_fact_array[Config_scene_spect_fact_array_size] =
  { 1e-6, 2e-6, 4e-6, 6e-6, 8e-6, 1e-5};
/*  smallest_wave, meters  */
const int Config_scene_small_wave_array_size = 22;
const float Config_scene_small_wave_array[Config_scene_small_wave_array_size] =
  { 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 2.0, 3.0, 4.0, 5.0,
    10.0, 15.0, 20.0, 30.0, 40.0, 50.0, 100.0 };
/*  wind_speed, m.s-1  */
const int Config_scene_wind_speed_array_size = 15;
const float Config_scene_wind_speed_array[Config_scene_wind_speed_array_size] =
  { 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0,
    45.0, 50.0 };
/*  wind_angle, radians  */
const int Config_scene_wind_angle_array_size = 2;
const float Config_scene_wind_angle_array[Config_scene_wind_angle_array_size] =
  { 0.0, Constant_pi_by_2 };
/*  surface_alpha, OpenGL value (opacity)  */
const int Config_scene_surf_alpha_array_size = 11;
const float Config_scene_surf_alpha_array[Config_scene_surf_alpha_array_size] =
  { 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0 };


#endif  /*  CONFIG_H  */
