/*  Emacs mode:  -*- C++ -*-  */

/*  frames per second  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef FPS_H
#define FPS_H


/****************  includes  ****************/


/*  C++ lib  */
#include <string>


/****************  namespaces  ****************/


using namespace std;


/****************  classes  ****************/


class Fps
{
 public:

  const int number_of_frames_max;


  /*
    Creates and inits a FPS counter.
    Average FPS will be computed every "number_of_frames_max" frames.
  */
  Fps(int number_of_frames_max, float current_time);
  virtual ~Fps(void);


  /*  set  */

  /*
    To be called each frame.
    "elapsed_time_lib" is the time taken by the library during the curent frame.
  */
  void set_elapsed_time(float current_time, float elapsed_time_lib);
  /*  re-inits Fps  */
  void reset(float current_time);


  /*  get  */

  void get_string(string *str) const;


 protected:

  int current_frame;
  /*  all time variables are in seconds  */
  float current_time;
  float time_total;
  float time_total_lib;
  float time_average;
  float time_average_lib;
};


#endif  /*  FPS_H  */
