/*  Begin aqua_rng.cpp  */

/*  random number generator  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/****************  includes  ****************/


#include "aqua_rng.h"

/*  GSL lib  */
extern "C"
{
#include <gsl/gsl_rng.h>
}

/*  C lib  */
extern "C"
{
#include <time.h>
}


/****************  public functions  ****************/


Aqua_Rng::Aqua_Rng(const gsl_rng_type *rng_type)
{
  unsigned long seed;  /*  RNG seed  */

  seed = time(NULL);
  this->generator = gsl_rng_alloc(rng_type);

  gsl_rng_set(this->generator, seed);
}


Aqua_Rng::~Aqua_Rng(void)
{
  gsl_rng_free(this->generator);
}


/*  End aqua_rng.cpp  */
