/*  Emacs mode: -*- C++ -*-  */

/*  random number generator with unit gaussian distribution  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _AQUA_RNG_UGAUSSIAN_H
#define _AQUA_RNG_UGAUSSIAN_H


/****************  includes  ****************/


#include "aqua_rng.h"

/*  GSL lib  */
extern "C"
{
#include <gsl/gsl_rng.h>
}


/****************  classes  ****************/


class Aqua_Rng_Ugaussian : public Aqua_Rng
{
 public:

  Aqua_Rng_Ugaussian(void);
  Aqua_Rng_Ugaussian(const gsl_rng_type *rng_type);

 
  /*  get  */

  /*  returns a random number of uniform gaussian distribution  */
  float get_number(void) const;


 protected:

  /*  copy constructor to be defined  */
  Aqua_Rng_Ugaussian(const class Aqua_Rng_Ugaussian &);
};


#endif  /*  _AQUA_RNG_UGAUSSIAN_H  */
