/*  Emacs mode: -*- C++ -*-  */

/*
  Copyright (C) 2003  Jocelyn Frchot

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 of the License.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _AQUA_WAVES_SET_H
#define _AQUA_WAVES_SET_H


/****************  classes  ****************/


class Aqua_Waves_Set
{
 public:

  const int points_x;  /*  numbers of discrete sample points...  */
  const int points_z;  /*  ...must be powers of two              */


  /*
    creates a set of "points_x" * "points_z" Aqua_Waves
    and fills "field_waves_magnitudes_[xz]" and "field_waves_unit_vector_[xz]"
  */
  Aqua_Waves_Set(int points_x,      /*  numbers of discrete sample points...  */
		 int points_z,      /*  ...must be powers of two              */
		 float size_x,                       /*  meters  */
		 float size_z,                       /*  meters  */
		 float depth,                        /*  meters  */
		 float basic_frequency,              /*  s-1  */
		 class Aqua_Wave_Factory *wave_factory,
		 class Aqua_Wave_Spectrum_Context *spectrum_context,
		 class Aqua_Rng *rng,
		 float **field_waves_magnitudes_x,
		 float **field_waves_magnitudes_z,
		 float **field_waves_unit_vector_x,
		 float **field_waves_unit_vector_z);
  virtual ~Aqua_Waves_Set(void);


  /****  set  ****/

  /*  depth in meters, basic_frequency in s-1  */
  void set_frequency(float depth, float basic_frequency);
  void set_spectrum(class Aqua_Wave_Spectrum_Context *spectrum_context);


  /****  get  ****/

  /*
    fills "amplitudes_array" of size "points_x" by "points_z",
    at time "time" (in seconds)
  */
  void get_fourier_amplitude(float time, float **amplitudes_array) const;


 protected:

  const int waves_set_size;     /*  points_x * points_z  */

  class Aqua_Wave* *waves_set;  /*  waves_set_size  */


  void waves_set_allocate(class Aqua_Wave_Factory *wave_factory,
			  int waves_set_size);
  void waves_set_free(int waves_set_size);
  class Aqua_Wave *get_waves_set(int index_x, int index_z) const;

  /*  copy constructor to be defined  */
  Aqua_Waves_Set(const class Aqua_Waves_Set &);
};


#endif  /*  _AQUA_WAVES_SET_H  */
