# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package Arch::LogPool;


1;

__END__

=head1 NAME

Arch::LogPool - optimal arch patch-log provider

=head1 SYNOPSIS 

=head1 DESCRIPTION

This class tries to serve all requested revision patch-logs in a minimal
time without taking much space. This is a singleton class, so there are
class methods only and no object methods.

The log cache may be optionality defined to optimize access to remote
archives among sessions.

=head1 METHODS

The following class methods are available:

B<get_log>,
B<register_log_file>,
B<register_changeset_dir>,
B<register_arch_tree>.

=over 4

=item B<get_log> I<full_revision>

Request Arch::Log object.

=back

=head1 BUGS

Awaiting for your reports.

=head1 CAVEATS

Currently, external utility I<tla> is spawned to gather any arch related
information. This may or may not cause problems on certain systems.
This module should work on POSIX systems with Perl >= 5.005.

=head1 AUTHORS

Mikhael Goikhman (migo@homemail.com--Perl-GPL/arch-perl--devel).

=head1 SEE ALSO

For more information, see L<tla>, L<Arch::Session>.

=cut
