#! /bin/sh
# check script for Rational - Rational number class with overflow detection
# Copyright (C) 2012-2024 Antonio Diaz Diaz.
#
# This script is free software: you have unlimited permission
# to copy, distribute, and modify it.

LC_ALL=C
export LC_ALL
objdir=`pwd`
testdir=`cd "$1" ; pwd`
RATIONAL="${objdir}"/rational
framework_failure() { echo "failure in testing framework" ; exit 1 ; }

if [ ! -f "${RATIONAL}" ] || [ ! -x "${RATIONAL}" ] ; then
	echo "${RATIONAL}: cannot execute"
	exit 1
fi

fail=0

printf "testing rational-%s..." "$2"

"${RATIONAL}" -t9 || fail=1

echo
if [ ${fail} = 0 ] ; then
	echo "tests completed successfully."
else
	echo "tests failed."
fi
exit ${fail}
