// generated by: arc -uRNMLP -A ./argrt -o cons.c -H cons.h -m cons.argl cons.arg 
#include "cons.h"

#line 115 "cons.arg"
static void simplify(argile_cons_t * * ca, argile_cons_t *, argile_cons_type_t *, int *);
/** :simplify <cons c> <(cons type) & t> <(int) & i>: -> nothing **/
#line 234 "cons.arg"
static char _hexachar(int);
/** :_hexachar <int n>: -> byte **/
#line 292 "cons.arg"
static unsigned char _cons_type_match(argile_cons_t *, argile_type_t, argile_type_t);
/** :_cons_type_match <cons> <argile type type> <argile type cmp>: -> bool **/

#line 56 "cons.arg"
argile_cons_t * argile_cons_new(argile_cons_type_t type, void * data)
/** :argile_cons_new <cons type type> <any data>: -> (argile) cons **/
{
#line 57 "cons.arg"
  argile_cons_t * cons = ((argile_cons_t *)0);

#line 57 "cons.arg"
  cons = ((argile_cons_t *)memset(argile_dbg_malloc(sizeof(argile_cons_t)), 0, sizeof(argile_cons_t)));
  (cons)->ctype = type;
  ((cons)->cvalue).data = data;
  switch (type) {
    case ARGILE_CONS_BIN: ;
    case ARGILE_CONS_OCT: ;
    case ARGILE_CONS_DEC: ;
    case ARGILE_CONS_HEX: {
      (cons)->type = (argile_type_t)ARGILE_TYPE_INTEGER;
    } break;
#line 66 "cons.arg"
    case ARGILE_CONS_REAL: {
      (cons)->type = (argile_type_t)ARGILE_TYPE_REAL;
    } break;
#line 68 "cons.arg"
    case ARGILE_CONS_TEXT: {
      (cons)->type = (argile_type_t)ARGILE_TYPE_TEXT;
    } break;
#line 70 "cons.arg"
    case ARGILE_CONS_CODE: {
      (cons)->type = (argile_type_t)ARGILE_TYPE_CODE;
    } break;
#line 72 "cons.arg"
    case ARGILE_CONS_SYNTAX: {
      (cons)->type = (argile_type_t)ARGILE_TYPE_SYNTAX;
    } break;
#line 74 "cons.arg"
    default: {} break;
  };
#line 75 "cons.arg"
  (cons)->rtype = (cons)->type;
  return cons;
}

#line 83 "cons.arg"
void argile_cons_del(argile_cons_t * p_argile_cons)
/** :argile_cons_del <cons>: -> nothing **/
{
#line 84 "cons.arg"
  switch ((p_argile_cons)->ctype) {
    case ARGILE_CONS_BIN: ;
    case ARGILE_CONS_OCT: ;
    case ARGILE_CONS_DEC: ;
    case ARGILE_CONS_HEX: ;
    case ARGILE_CONS_REAL: {
      argile_dbg_free(((p_argile_cons)->cvalue).data);
    } break;
#line 91 "cons.arg"
    case ARGILE_CONS_TEXT: {
      argile_text_del(((p_argile_cons)->cvalue).text);
    } break;
#line 93 "cons.arg"
    case ARGILE_CONS_CODE: {
      argile_code_del(((p_argile_cons)->cvalue).code);
    } break;
#line 95 "cons.arg"
    case ARGILE_CONS_SYNTAX: {
      argile_list_del(((p_argile_cons)->cvalue).syntax);
    } break;
#line 97 "cons.arg"
    default: {} break;
  };
#line 98 "cons.arg"
  argile_dbg_free(p_argile_cons);
}

#line 106 "cons.arg"
int argile_cons_eq(argile_cons_t * ca, argile_cons_t * cb)
/** :argile_cons_eq <cons ca> <cons cb>: -> int **/
{
#line 111 "cons.arg"
  argile_cons_type_t ta;
#line 111 "cons.arg"
  argile_cons_type_t tb;
  int ia = 0;
#line 112 "cons.arg"
  int ib = 0;

#line 107 "cons.arg"
  if ((ca == cb)) {
    return 1;
  } //;
#line 109 "cons.arg"
  if (((ca == NULL) || (cb == NULL))) {
    return 0;
  } //;
#line 113 "cons.arg"
  simplify(&ca, ca, &ta, &ia);
  simplify(&ca, cb, &tb, &ib);
#line 137 "cons.arg"
  if ((ta != tb)) {
#line 137 "cons.arg"
    return 0;
  } //;
#line 138 "cons.arg"
  switch (ta) {
    case ARGILE_CONS_DEC: {
      return (((ia == ib)) ? (1) : (0));
    } break;
#line 141 "cons.arg"
    case ARGILE_CONS_REAL: {
      double ra = 0.0;
#line 142 "cons.arg"
      double rb = 0.0;

#line 143 "cons.arg"
      ra = strtod(((ca)->cvalue).real, NULL);
      rb = strtod(((cb)->cvalue).real, NULL);
      return (((ra == rb)) ? (1) : (0));
    } break;
#line 146 "cons.arg"
    case ARGILE_CONS_TEXT: {
      return (((strcmp((((ca)->cvalue).text)->str, (((cb)->cvalue).text)->str) == 0)) ? (1) : (0));
    } break;
#line 148 "cons.arg"
    case ARGILE_CONS_CODE: {
      argile_code_t * xa = ((argile_code_t *)0);
#line 149 "cons.arg"
      argile_code_t * xb = ((argile_code_t *)0);

#line 149 "cons.arg"
      xa = ((ca)->cvalue).code;
      xb = ((cb)->cvalue).code;
#line 150 "cons.arg"
      if ((((xa)->calls == NULL) && ((xb)->calls == NULL))) {
        return 1;
      } //;
#line 152 "cons.arg"
      return 0;
    } break;
#line 153 "cons.arg"
    case ARGILE_CONS_SYNTAX: {
      return 1;
    } break;
#line 155 "cons.arg"
    default: {} break;
  };
#line 156 "cons.arg"
  return 0;
}

#line 165 "cons.arg"
void argile_cons_string(argile_cons_t * p_argile_cons_2, int indent, argile_buff_t * buf)
/** :argile_cons_string <cons> <int indent> <buff buf>: -> nothing **/
{
#line 166 "cons.arg"
  switch ((p_argile_cons_2)->ctype) {
    case ARGILE_CONS_HEX: ;
    case ARGILE_CONS_DEC: ;
    case ARGILE_CONS_OCT: ;
    case ARGILE_CONS_BIN: ;
    case ARGILE_CONS_REAL: {
      argile_buff_puts(buf, ((char *)((p_argile_cons_2)->cvalue).data));
    } break;
#line 173 "cons.arg"
    case ARGILE_CONS_TEXT: {
      argile_cons_text_string(((p_argile_cons_2)->cvalue).text, buf);
    } break;
#line 175 "cons.arg"
    case ARGILE_CONS_CODE: {
#line 182 "cons.arg"
      unsigned char b;
#line 186 "cons.arg"
      int i = 0;

#line 176 "cons.arg"
      if ((argile).skip_codes) {
        argile_buff_puts(buf, "{...}");
        break;
      } //;
#line 179 "cons.arg"
      if (((((p_argile_cons_2)->cvalue).code)->calls == NULL)) {
        argile_buff_puts(buf, "{}");
        break;
      } //;
#line 182 "cons.arg"
      b = (!((argile).dump_indent) || (((((p_argile_cons_2)->cvalue).code)->owner)->owner));
      if (b) {
#line 183 "cons.arg"
        argile_buff_putc(buf, *&("{")[0]);
      } //;
#line 184 "cons.arg"
      argile_buff_putc(buf, '\n');
      argile_code_string(((p_argile_cons_2)->cvalue).code, (indent + 1), buf);
      for (i = 1; ((i <= indent)); (i)++) {
#line 186 "cons.arg"
        argile_buff_puts(buf, "  ");
      };
#line 187 "cons.arg"
      if (b) {
#line 187 "cons.arg"
        argile_buff_putc(buf, *&("}")[0]);
      } //;
    } break;
#line 188 "cons.arg"
    case ARGILE_CONS_SYNTAX: {
      argile_buff_putc(buf, *&(":")[0]);
      argile_syntax_string(((p_argile_cons_2)->cvalue).syntax, buf);
      argile_buff_putc(buf, *&(":")[0]);
    } break;
#line 192 "cons.arg"
    default: {
      argile_buff_puts(buf, "(: bad constant type ");
      argile_buff_putn(buf, ((int)(p_argile_cons_2)->ctype));
      argile_buff_puts(buf, " :)");
    } break;
  };
}

#line 202 "cons.arg"
void argile_cons_text_string(argile_text_t * t, argile_buff_t * b)
/** :argile_cons_text_string <argile text t> <buff b>: -> nothing **/
{
#line 203 "cons.arg"
  unsigned char after_hex;

#line 203 "cons.arg"
  after_hex = 0;
  argile_buff_putc(b, *&("\"")[0]);
  if ((t)) {
    int i = 0;

#line 207 "cons.arg"
    for (i = 0; (i < (t)->len); (i)++) {
      unsigned char is_hex;
      char c;

#line 208 "cons.arg"
      is_hex = 0;
      switch ((c = *&((t)->str)[i])) {
        case '"': {
#line 210 "cons.arg"
          argile_buff_puts(b, "\\\"");
        } break;
#line 211 "cons.arg"
        case '\\': {
#line 211 "cons.arg"
          argile_buff_puts(b, "\\\\");
        } break;
#line 212 "cons.arg"
        case '\a': {
#line 212 "cons.arg"
          argile_buff_puts(b, "\\a");
        } break;
#line 213 "cons.arg"
        case '\b': {
#line 213 "cons.arg"
          argile_buff_puts(b, "\\b");
        } break;
#line 214 "cons.arg"
        case '\t': {
#line 214 "cons.arg"
          argile_buff_puts(b, "\\t");
        } break;
#line 215 "cons.arg"
        case '\n': {
#line 215 "cons.arg"
          argile_buff_puts(b, "\\n");
        } break;
#line 216 "cons.arg"
        case '\v': {
#line 216 "cons.arg"
          argile_buff_puts(b, "\\v");
        } break;
#line 217 "cons.arg"
        case '\f': {
#line 217 "cons.arg"
          argile_buff_puts(b, "\\f");
        } break;
#line 218 "cons.arg"
        case '\r': {
#line 218 "cons.arg"
          argile_buff_puts(b, "\\r");
        } break;
#line 219 "cons.arg"
        default: {
#line 225 "cons.arg"
          if (((argile).hexa_str && (((c < ' ') || (c > '~')) || (after_hex && ((((c >= '0') && (c <= '9')) || ((c >= 'a') && (c <= 'f'))) || ((c >= 'A') && (c <= 'F'))))))) {
#line 230 "cons.arg"
            argile_buff_puts(b, "\\x");
            argile_buff_putc(b, _hexachar(((int)(c >> 4))));
            argile_buff_putc(b, _hexachar(((int)c)));
            is_hex = 1;
          } //;
#line 240 "cons.arg"
          else {
            argile_buff_putc(b, c);
          };
        } break;
      };
#line 242 "cons.arg"
      after_hex = is_hex;
    };
  } //;
#line 243 "cons.arg"
  argile_buff_putc(b, *&("\"")[0]);
}

#line 250 "cons.arg"
void argile_cons_setup(argile_cons_t * p_argile_cons_3, argile_call_t * owner)
/** :argile_cons_setup <cons> <call owner>: -> nothing **/
{
#line 251 "cons.arg"
  if (((p_argile_cons_3)->ctype == ARGILE_CONS_CODE)) {
    (((p_argile_cons_3)->cvalue).code)->owner = owner;
    (((p_argile_cons_3)->cvalue).code)->upper = (owner)->scope;
  } //;
}

#line 262 "cons.arg"
int argile_cons_match_type(argile_cons_t * p_argile_cons_4, argile_type_t type_2)
/** :argile_cons_match_type <cons> <argile type type>: -> int **/
{
#line 263 "cons.arg"
  if ((((((int)type_2) >> 31) & 1))) {
#line 464 "./argrt/std.argl"
    return 0;
  } //;
#line 264 "cons.arg"
  switch ((p_argile_cons_4)->ctype) {
    case ARGILE_CONS_HEX: ;
    case ARGILE_CONS_DEC: ;
    case ARGILE_CONS_OCT: ;
    case ARGILE_CONS_BIN: {
      if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_INTEGER)) {
        return 1;
      } //;
#line 271 "cons.arg"
      if ((*&(((p_argile_cons_4)->cvalue).dec)[0] != '-')) {
        if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_NATURAL)) {
          return 1;
        } //;
      } //;
#line 274 "cons.arg"
      return 0;
    } break;
#line 275 "cons.arg"
    case ARGILE_CONS_REAL: {
      if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_REAL)) {
        return 1;
      } //;
#line 278 "cons.arg"
      return 0;
    } break;
#line 279 "cons.arg"
    case ARGILE_CONS_TEXT: {
      if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_TEXT)) {
        return 1;
      } //;
#line 282 "cons.arg"
      return 0;
    } break;
#line 283 "cons.arg"
    case ARGILE_CONS_CODE: {
      if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_CODE)) {
        return 1;
      } //;
#line 286 "cons.arg"
      return 0;
    } break;
#line 287 "cons.arg"
    case ARGILE_CONS_SYNTAX: {
      if (_cons_type_match(p_argile_cons_4, type_2, (argile_type_t)ARGILE_TYPE_SYNTAX)) {
        return 1;
      } //;
#line 290 "cons.arg"
      return 0;
    } break;
#line 291 "cons.arg"
    default: {} break;
  };
#line 300 "cons.arg"
  return 0;
}

#line 306 "cons.arg"
void argile_cons_gencode(argile_cons_t * p_argile_cons_5)
/** :argile_cons_gencode <cons>: -> nothing **/
{
#line 307 "cons.arg"
  switch ((p_argile_cons_5)->ctype) {
    case ARGILE_CONS_HEX: ;
    case ARGILE_CONS_DEC: ;
    case ARGILE_CONS_OCT: ;
    case ARGILE_CONS_REAL: {
      argile_puts(((char *)((p_argile_cons_5)->cvalue).data));
    } break;
#line 313 "cons.arg"
    case ARGILE_CONS_BIN: {
      char * digits = "";

#line 314 "cons.arg"
      digits = ((p_argile_cons_5)->cvalue).bin;
      while ((((*&(digits)[0] != '\0') && (*&(digits)[0] != 'b')) && (*&(digits)[0] != 'B'))) {
        (digits)++;
      };
#line 317 "cons.arg"
      if ((*&(digits)[0])) {
        (digits)++;
      } //;
#line 319 "cons.arg"
      if ((*&(((p_argile_cons_5)->cvalue).bin)[0] == '-')) {
        argile_puts("-");
      } //;
#line 321 "cons.arg"
      argile_printf("0x%llx", strtoll(digits, NULL, 2));
    } break;
#line 322 "cons.arg"
    case ARGILE_CONS_TEXT: {
      argile_buff_t b_2 = ((argile_buff_t){0});

#line 324 "cons.arg"
      argile_cons_text_string(((p_argile_cons_5)->cvalue).text, &b_2);
      argile_output((b_2).ptr, ((int)(b_2).len));
      argile_dbg_free((b_2).ptr);
    } break;
#line 327 "cons.arg"
    case ARGILE_CONS_CODE: {
      argile_code_t * code = ((argile_code_t *)0);

#line 328 "cons.arg"
      code = ((p_argile_cons_5)->cvalue).code;
      if (((code)->anon)) {
        argile_printf("(void *)&%s", (code)->anon);
      } //;
#line 331 "cons.arg"
      else if (((code)->calls)) {
        argile_puts("{\n");
        ((argile).indent)++;
        argile_code_gen_vars(code, 0);
        argile_code_gencode(code);
        ((argile).indent)--;
        argile_indent();
        argile_puts("}");
      } //;
#line 339 "cons.arg"
      else {
        argile_puts("{}");
      };
    } break;
#line 341 "cons.arg"
    case ARGILE_CONS_SYNTAX: {
      argile_buff_t b_2 = ((argile_buff_t){0});
      unsigned char old;

#line 343 "cons.arg"
      old = (argile).use_colors;
      if (old) {
#line 344 "cons.arg"
        (argile).use_colors = 0;
      } //;
#line 345 "cons.arg"
      argile_buff_puts(&b_2, "\":");
      argile_syntax_string(((p_argile_cons_5)->cvalue).syntax, &b_2);
      argile_buff_escape(&b_2, "\\", '\\');
      argile_buff_puts(&b_2, ":\"");
      if (old) {
#line 349 "cons.arg"
        (argile).use_colors = 1;
      } //;
#line 350 "cons.arg"
      argile_output((b_2).ptr, ((int)(b_2).len));
      argile_dbg_free((b_2).ptr);
    } break;
#line 352 "cons.arg"
    default: {} break;
  };
}

#line 115 "cons.arg"
static void simplify(argile_cons_t * * ca, argile_cons_t * c, argile_cons_type_t * t_2, int * i)
/** :simplify <cons c> <(cons type) & t> <(int) & i>: -> nothing **/
{
#line 116 "cons.arg"
  switch ((c)->ctype) {
    case ARGILE_CONS_HEX: {
      *t_2 = ARGILE_CONS_DEC;
      *i = strtol(((c)->cvalue).hex, NULL, 16);
    } break;
#line 120 "cons.arg"
    case ARGILE_CONS_DEC: {
      *t_2 = ARGILE_CONS_DEC;
      *i = strtol(((c)->cvalue).dec, NULL, 10);
    } break;
#line 123 "cons.arg"
    case ARGILE_CONS_OCT: {
      *t_2 = ARGILE_CONS_DEC;
      *i = strtol(((c)->cvalue).oct, NULL, 8);
    } break;
#line 126 "cons.arg"
    case ARGILE_CONS_BIN: {
#line 128 "cons.arg"
      char * str = "";

#line 127 "cons.arg"
      *t_2 = ARGILE_CONS_DEC;
      str = ((*ca)->cvalue).bin;
      if ((*&(str)[0] == '-')) {
        *i = (-strtol(((str) + 3), NULL, 2));
      } //;
#line 131 "cons.arg"
      else {
        *i = strtol(((str) + 2), NULL, 2);
      };
    } break;
#line 133 "cons.arg"
    default: {
      *t_2 = (c)->ctype;
      *i = 0;
    } break;
  };
}

#line 234 "cons.arg"
static char _hexachar(int n)
/** :_hexachar <int n>: -> byte **/
{
#line 235 "cons.arg"
  n &= 0xf;
  if ((n < 10)) {
    return (n + '0');
  } //;
#line 238 "cons.arg"
  return ((n - 10) + 'a');
}

#line 292 "cons.arg"
static unsigned char _cons_type_match(argile_cons_t * p_argile_cons_6, argile_type_t type_3, argile_type_t cmp)
/** :_cons_type_match <cons> <argile type type> <argile type cmp>: -> bool **/
{
#line 293 "cons.arg"
  unsigned char t_2;

#line 293 "cons.arg"
  t_2 = (type_3 == ARGILE_TYPE_ANYTHING);
  if (!(t_2)) {
#line 294 "cons.arg"
    t_2 = (argile_type_match(type_3, cmp));
  } //;
#line 295 "cons.arg"
  if (!(t_2)) {
#line 295 "cons.arg"
    return 0;
  } //;
#line 296 "cons.arg"
  (p_argile_cons_6)->type = cmp;
  (p_argile_cons_6)->rtype = type_3;
  return t_2;
}

