// generated by: arc -uRNMLP -o dbg.c -H dbg.h -m dbg.argl dbg.arg 
#include "dbg.h"

#line 30 "dbg.arg"
int dbg_allocs = 0;
#line 30 "dbg.arg"
int dbg_frees = 0;

#line 33 "dbg.arg"
void dbg_free(void * ptr)
/** :dbg_free <any ptr>: -> nothing **/
{
#line 34 "dbg.arg"
  (dbg_frees)++;
#line 39 "dbg.arg"
  if ((dbg_frees > dbg_allocs)) {
    fprintf(stderr, "debug: %d allocs but %d frees !\n", dbg_allocs, dbg_frees);
  } //;
#line 41 "dbg.arg"
  if ((ptr == NULL)) {
    fprintf(stderr, "debug: free (nil) !\n");
  } //;
#line 43 "dbg.arg"
  free(ptr);
}

void * dbg_malloc(unsigned int size)
/** :dbg_malloc <nat size>: -> anything **/
{
#line 48 "dbg.arg"
  void * ptr_2 = NULL;

#line 47 "dbg.arg"
  (dbg_allocs)++;
  ptr_2 = malloc(size);
#line 53 "dbg.arg"
  if ((ptr_2 == NULL)) {
    fprintf(stderr, "debug: malloc = NULL ! memory exhausted ?\n");
  } //;
#line 55 "dbg.arg"
  return (void *)ptr_2;
}

void * dbg_realloc(void * ptr_2, unsigned int size_2)
/** :dbg_realloc <any ptr> <nat size>: -> anything **/
{
#line 59 "dbg.arg"
  void * re = NULL;

#line 59 "dbg.arg"
  re = realloc(ptr_2, size_2);
  if ((re != ptr_2)) {
    if ((ptr_2)) {
      (dbg_frees)++;
    } //;
#line 67 "dbg.arg"
    dbg_count_malloc(re);
  } //;
#line 68 "dbg.arg"
  if ((re == NULL)) {
    fprintf(stderr, "debug: realloc = NULL ! memory exhausted ?\n");
  } //;
#line 70 "dbg.arg"
  return (void *)re;
}

char * dbg_strdup(char * p_text)
/** :dbg_strdup <text>: -> text **/
{
#line 74 "dbg.arg"
  char * dup = "";

#line 74 "dbg.arg"
  dup = ((char *)strdup(p_text));
  dbg_count_malloc(dup);
  return dup;
}

void dbg_count_malloc(void * ptr_3)
/** :dbg_count_malloc <any ptr>: -> nothing **/
{
#line 80 "dbg.arg"
  (dbg_allocs)++;
#line 85 "dbg.arg"
  if ((ptr_3 == NULL)) {
    fprintf(stderr, "debug: count alloc (nil) ! memory exhausted ?\n");
  } //;
}

#line 89 "dbg.arg"
void dbg_check_mem_leak()
/** :dbg_check_mem_leak: -> nothing **/
{
#line 90 "dbg.arg"
  if ((dbg_frees < dbg_allocs)) {
    fprintf(stderr, "debug: memory leak: frees/allocs: %d/%d !\n", dbg_frees, dbg_allocs);
  } else if ((dbg_frees > dbg_allocs)) {
    fprintf(stderr, "debug: memory bug: frees/allocs: %d/%d !\n", dbg_frees, dbg_allocs);
  } //;
}

