// generated by: arc -xuNP -A ./../argrt -M -o argilectx.c -H argilectx.h -m argilectx.argl.tmp argilectx.arg 
#include "argile.h" //;
#include <compiler/parser.h> //;

#include "argilectx.h"

static void attribute_comments_to_calls();
/** :attribute comments to calls: -> nothing **/
static void print_line(char *, int);
/** :print line <text dst> <int len>: -> nothing **/
static int ends_by(char *, int, char *);
/** :<text str> ends by <int n> <text end>: -> int **/
static argile_file_t * try_new_file(char *);
/** :try new file <text path>: -> (argile) file **/
static char * convert_to_daltonism(char *);
/** :convert <text colour> to daltonism: -> text **/
static unsigned char is_not_included(argile_code_t *);
/** :<argile code c> is not included: -> bool **/
static unsigned char argile_pos_su_argile_pos(argile_pos_t *, argile_pos_t *);
/** :<pos a> > <pos b>: -> bool **/
static void comment(comment_t *);
/** :<comment c>: -> nothing **/
static void print_define(argile_file_t * * file, int * size, char * * name);
/** :print define: -> nothing **/
static int get_word_size_of(char *);
/** :get word size of <text t>: -> int **/
static void write_ref_or_raw_in_with(argile_buff_t *, argile_buff_t *, argile_def_t *, char *);
/** :write ref or raw <buff tb> in <buff out> with <def d> <text name>: -> nothing **/
static void add_include(char *);
/** :add include <text p>: -> nothing **/
static argile_file_t * try_in_dir(char *, int, char *, int);
/** :try <text path> <int plen> in dir <text dir> <int dlen>: -> (argile) file **/
static void strip_useless_slashes_in(char *);
/** :strip useless slashes in <text s>: -> nothing **/
static unsigned char doesn_t_end_by_ext(char *);
/** :<text str> doesn ' t end by ext: -> bool **/
static int cached_stat(char *, struct stat *);
/** :cached - stat <text p> <stat st>: -> int **/
static void reduce(char *, char *);
/** :reduce <text d> <text s>: -> nothing **/
static int id_end_num(char *, unsigned int, int *);
/** :id end num <text s> <nat n> <(int) & num>: -> int **/
static void check_id_num(argile_buff_t *, char *, unsigned char *, int *, int *);
/** :check id num <buff b> <text id> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
static void check_call_id_num(argile_call_t *, argile_buff_t *, unsigned char *, int *, int *);
/** :check call id num <call> <buff b> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
static void search_in_with(argile_list_t *, argile_code_t *, void (*)(argile_def_t *));
/** :search <list of (argile syntax) syn> in <argile code code> with <function (def) callback>: -> nothing **/
static void search_in_with_2(argile_list_t *, argile_call_t *, void (*)(argile_def_t *));
/** :search <list of (argile syntax) syn> in <call> with <function (def) callback>: -> nothing **/
static void split_op(char *, int, int);
/** :split op <text str> <int len> <int optoken>: -> nothing **/
static argile_list_t * new_range(unsigned int, unsigned int);
/** :new range <nat a> <nat b>: -> list of (array of (nat)) **/

argile_t argile = ((argile_t){0});

int argile_init()
/** :argile_init: -> int **/
{
  memset(&argile, 0, sizeof(*&argile));
  (argile).colpertab = 8;
  (argile).maxmatch = 500;
  (argile).maxcomp = 1000;
  (argile).maxgen = 500;
  (argile).maxreject = 5;
  (argile).next_type = ((int)ARGILE_NEXT_TYPE);
  ((argile).enc_utf8).charsize = (void *)&argile_utf8_charsize;
  ((argile).enc_utf8).charat = (void *)&argile_utf8_charat;
  (argile).output = (void *)&argile_output_file;
  (argile).output_data = stdout;
  (argile).output_name = "standard output";
  (argile).output_line = 1;
  (argile).last_input_line = 1;
  (argile).next_input_buff = argile_buff_new(512);
  (argile).get_comments = 1;
  (argile).signbuffer = argile_buff_new(512);
  argile_add_keyword("auto");
  argile_add_keyword("break");
  argile_add_keyword("case");
  argile_add_keyword("char");
  argile_add_keyword("const");
  argile_add_keyword("continue");
  argile_add_keyword("default");
  argile_add_keyword("do");
  argile_add_keyword("double");
  argile_add_keyword("else");
  argile_add_keyword("enum");
  argile_add_keyword("extern");
  argile_add_keyword("float");
  argile_add_keyword("for");
  argile_add_keyword("goto");
  argile_add_keyword("if");
  argile_add_keyword("int");
  argile_add_keyword("long");
  argile_add_keyword("register");
  argile_add_keyword("return");
  argile_add_keyword("short");
  argile_add_keyword("signed");
  argile_add_keyword("sizeof");
  argile_add_keyword("static");
  argile_add_keyword("struct");
  argile_add_keyword("switch");
  argile_add_keyword("typedef");
  argile_add_keyword("union");
  argile_add_keyword("unsigned");
  argile_add_keyword("void");
  argile_add_keyword("volatile");
  argile_add_keyword("while");
  argile_add_reserved("anon_arg");
  argile_add_reserved("anon_va");
  return 0;
}

void argile_uninit()
/** :argile_uninit: -> nothing **/
{
  int i_2 = 0;

  argile_choke_leaks();
  if (((argile).error != NULL)) {
    argile_dbg_free((argile).error);
  } //;
  for (i_2 = 0; (i_2 < 512); (i_2)++) {
    argile_list_del(((argile).types)[i_2]);
  };
  if ((((argile).main != NULL) && is_not_included((argile).main))) {
    argile_code_del((argile).main);
  } //;
  for (i_2 = 0; (i_2 < 1024); (i_2)++) {
    argile_list_del(((argile).ids)[i_2]);
  };
  for (i_2 = 0; (i_2 < 4096); (i_2)++) {
    argile_list_del(((argile).defs)[i_2]);
    *&((argile).defs)[i_2] = ((argile_list_t *)0);
  };
  argile_list_del((argile).used);
  argile_list_del((argile).mods);
  argile_list_del((argile).file_path);
  argile_list_del((argile).globally);
  argile_list_del((argile).includes);
  argile_list_del((argile).sysincludes);
  argile_list_del((argile).op_ranges);
  argile_list_del((argile).options);
  argile_list_del((argile).keywords);
  argile_list_del((argile).reserved);
  argile_list_del((argile).warns);
  argile_list_del((argile).stat_fails);
  argile_list_del((argile).comments);
  argile_buff_del((argile).next_input_buff);
  argile_buff_del((argile).signbuffer);
  memset(&argile, 0, sizeof(*&argile));
}

char * argile_get_option(char * opt)
/** :argile_get_option <text opt>: -> text **/
{
  argile_list_t * lo;

  lo = (argile).options;
  while (!(((lo == NULL) || (((argile_list_t *)lo)->next == NULL)))) {
    if ((strcmp(*((char * *)&((argile_list_t *)lo)->data), opt) == 0)) {
      return *((char * *)&((argile_list_t *)((argile_list_t *)lo)->next)->data);
    } //;
    lo = ((argile_list_t *)lo)->next;
  };
  return (char *)0;
}

int argile_parse(void * data)
/** :argile_parse <any data>: -> int **/
{
  int ret = 0;

  (argile).input_data = data;
  (argile).input_ended = 0;
  (argile).separator = 0;
  (argile).new_line = 1;
  (argile).indents = ((argile_list_t *)0);
  (argile).tokens = ((argile_list_t *)0);
  (argile).last_token = ((argile_list_t *)0);
  (((argile).loc).start).row = 1;
  (((argile).loc).start).col = 0;
  (((argile).loc).end).row = 1;
  (((argile).loc).end).col = 0;
  (argile).linebuff = argile_buff_new(0);
  argile_resurrect();
  ret = argile_yyparse();
  ((((argile).loc).end).row)--;
  argile_buff_del((argile).linebuff);
  (argile).linebuff = ((argile_buff_t *)0);
  argile_list_del((argile).indents);
  (argile).indents = ((argile_list_t *)0);
  argile_list_del((argile).tokens);
  (argile).tokens = ((argile_list_t *)0);
  (argile).last_token = ((argile_list_t *)0);
  if (((argile).error)) {
    argile_choke_leaks();
    if ((((argile).main) && (((argile).main)->calls))) {
      ((argile).main)->calls = ((argile_list_t *)0);
    } //;
    return -1;
  } //;
  argile_forget_leaks();
  attribute_comments_to_calls();
  return ret;
}

static void attribute_comments_to_calls()
/** :attribute comments to calls: -> nothing **/
{
  argile_list_t * lcall;
  argile_list_t * lcomm;

  if (!((argile).get_comments)) {
    return;
  } //;
  if (((argile).main == NULL)) {
    return;
  } //;
  lcall = ((argile).main)->calls;
  lcomm = argile_list_start((argile).comments);
  while (!(((lcall == NULL) || (lcomm == NULL)))) {
    comment_t * comm = ((comment_t *)0);
    argile_pos_t * pcomm = ((argile_pos_t *)0);

    comm = *((comment_t * *)&((argile_list_t *)lcomm)->data);
    pcomm = &(comm)->pos;
    while (!(((lcall == NULL) || argile_pos_su_argile_pos(&((*((argile_call_t * *)&((argile_list_t *)lcall)->data))->loc).start, pcomm)))) {
      lcall = ((argile_list_t *)lcall)->next;
    };
    if (!((lcall == NULL))) {
      argile_call_t * call = ((argile_call_t *)0);

      call = *((argile_call_t * *)&((argile_list_t *)lcall)->data);
      if (((call)->comment)) {
        argile_dbg_free((call)->comment);
      } //;
      (call)->comment = (comm)->txt;
      (comm)->txt = (char *)0;
    } //;
    lcomm = ((argile_list_t *)lcomm)->next;
  };
}

int argile_compile()
/** :argile_compile: -> int **/
{
  int r = 0;

  r = argile_compile_as((argile_type_t)ARGILE_TYPE_ANYTHING);
  argile_add_gstats();
  return r;
}

int argile_compile_as(argile_type_t t)
/** :argile_compile_as <argile type t>: -> int **/
{
  if (!(((argile).main))) {
    return 0;
  } //;
  return argile_code_compile((argile).main, t);
}

void argile_add_comment(char * txt, int line, int col)
/** :argile_add_comment <text txt> <int line> <int col>: -> nothing **/
{
  comment_t * cmt = ((comment_t *)0);

  if ((*&(txt)[0] != *&(":")[0])) {
    argile_dbg_free(txt);
    return;
  } //;
  cmt = ((comment_t *)memset(argile_dbg_malloc(sizeof(comment_t)), 0, sizeof(comment_t)));
  (cmt)->txt = txt;
  ((cmt)->pos).row = line;
  ((cmt)->pos).col = col;
  argile_list_append(&(argile).comments, argile_list_new(cmt, (void *)&comment));
}

void argile_add_keyword(char * word)
/** :argile_add_keyword <text word>: -> nothing **/
{
  unsigned int hash = 0;

  hash = (argile_hash(word) % 1024);
  argile_list_prepend(&((argile).ids)[hash], argile_list_new(word, ((argile_deleter_t)0)));
  argile_list_prepend(&(argile).keywords, argile_list_new(word, ((argile_deleter_t)0)));
}

void argile_add_reserved(char * word_2)
/** :argile_add_reserved <text word>: -> nothing **/
{
  unsigned int hash = 0;

  hash = (argile_hash(word_2) % 1024);
  argile_list_prepend(&((argile).ids)[hash], argile_list_new(word_2, ((argile_deleter_t)0)));
  argile_list_prepend(&(argile).reserved, argile_list_new(word_2, ((argile_deleter_t)0)));
}

void argile_gencode(char * header)
/** :argile_gencode <text header>: -> nothing **/
{
  argile_list_t * lc;

  if (((argile).globally != NULL)) {
    for (lc = argile_list_end((argile).globally); (lc); lc = ((argile_list_t *)lc)->prev) {
      argile_code_t * code = ((argile_code_t *)0);

      code = *((argile_code_t * *)&((argile_list_t *)lc)->data);
      if (!((code)->compiled)) {
        unsigned char old;

        old = (argile).main_only;
        (argile).main_only = 0;
        argile_code_compile(code, (code)->type);
        (argile).main_only = old;
      } //;
      argile_code_gencode(code);
    };
    argile_puts("\n");
  } //;
  argile_code_pregen_ids((argile).main);
  argile_find_all_autoparams();
  if ((header)) {
    argile_printf("#include \"%s\"\n\n", header);
  } //;
  else {
    argile_gen_header((char *)0);
  };
  argile_code_gen_typedefs((argile).main, 1);
  argile_code_gen_enums((argile).main, 1);
  argile_code_gen_structs_and_unions((argile).main, 1);
  argile_code_gen_protos((argile).main, 1);
  argile_code_gen_vars((argile).main, 0);
  for (lc = (argile).globally; (lc); lc = ((argile_list_t *)lc)->next) {
    argile_code_gen_vars(*((argile_code_t * *)&((argile_list_t *)lc)->data), 0);
  };
  argile_code_gen_private_vars((argile).main);
  argile_code_gen_funcs((argile).main);
  if ((argile).do_main) {
    argile_code_gen_main((argile).main);
  } //;
  argile_flush_refs();
}

void argile_gen_header(char * name)
/** :argile_gen_header <text name>: -> nothing **/
{
  int size = 0;
  argile_file_t * file = ((argile_file_t *)0);

  if ((name)) {
    char * s = "";
    int match = 0;
    argile_list_t * lf;

    s = strrchr(name, '/');
    if ((s)) {
      name = ((s) + 1);
    } //;
    size = get_word_size_of(name);
    lf = (argile).used;
    for (; (lf); lf = ((argile_list_t *)lf)->next) {
      argile_file_t * f = ((argile_file_t *)0);
      int sz = 0;

      f = *((argile_file_t * *)&((argile_list_t *)lf)->data);
      s = strrchr((f)->path, '/');
      if ((s)) {
        (s)++;
      } //;
      else {
        s = (f)->path;
      };
      sz = get_word_size_of(s);
      if (((sz == size) && (strncmp(s, name, sz) == 0))) {
        (match)++;
        file = f;
      } //;
    };
    if ((match != 1)) {
      file = ((argile_file_t *)0);
    } //;
    argile_puts("#ifndef ");
    print_define(&file, &size, &name);
    argile_puts("\n#define ");
    print_define(&file, &size, &name);
    argile_puts("\n\n");
  } //;
  argile_code_gen_defines((argile).main);
  argile_code_gen_typedefs((argile).main, 0);
  argile_code_gen_includes((argile).main);
  argile_code_gen_enums((argile).main, 0);
  argile_code_gen_structs_and_unions((argile).main, 0);
  if ((name)) {
    argile_code_gen_vars((argile).main, 2);
  } //;
  else {
    argile_code_gen_vars((argile).main, 1);
  };
  argile_code_gen_protos((argile).main, 0);
  if ((name)) {
    argile_puts("#endif /* ");
    print_define(&file, &size, &name);
    argile_puts(" */\n");
  } //;
}

void argile_gen_module(FILE * f)
/** :argile_gen_module <FILE f>: -> nothing **/
{
  argile_buff_t s = ((argile_buff_t){0});
  argile_buff_t t_2 = ((argile_buff_t){0});
  argile_call_t * c = ((argile_call_t *)0);
  char * new_line = "";
  unsigned char old;
  argile_module_t * mod = ((argile_module_t *)0);
  argile_def_t * duse = ((argile_def_t *)0);
  argile_def_t * dinc = ((argile_def_t *)0);
  argile_def_t * dvar = ((argile_def_t *)0);
  argile_def_t * dfunc = ((argile_def_t *)0);
  argile_def_t * dext = ((argile_def_t *)0);
  argile_def_t * dnodecl = ((argile_def_t *)0);
  argile_def_t * dtref = ((argile_def_t *)0);
  argile_def_t * dtraw = ((argile_def_t *)0);

  new_line = (((argile).dump_indent) ? ("\n") : (";\n"));
  old = (argile).use_colors;
  (argile).use_colors = 0;
  mod = argile_getmod("std");
  if ((mod)) {
    argile_list_t * lx;

    lx = ((argile).main)->calls;
    for (; (lx); lx = ((argile_list_t *)lx)->next) {
      argile_def_t * d = ((argile_def_t *)0);

      c = *((argile_call_t * *)&((argile_list_t *)lx)->data);
      d = (c)->def;
      if ((((d) && ((d)->dtype == ARGILE_DEF_BIND)) && (((d)->dval).bind)->modulable)) {
        argile_buff_flush(&s);
        argile_call_string(c, 0, &s);
        if (((s).ptr)) {
          if (((c)->comment)) {
            fprintf(f, "(:%s:)\n", (c)->comment);
          } //;
          fwrite((s).ptr, (s).len, 1, f);
        } //;
        fputs(new_line, f);
      } //;
    };
  } //;
  else {
    argile_list_t * p = ((argile_list_t *)0);
    argile_list_t * lx;
    argile_list_t * lp;

    lx = (argile).used;
    for (; (lx); lx = ((argile_list_t *)lx)->next) {
      argile_file_t * fp = ((argile_file_t *)0);
      argile_code_t * u = ((argile_code_t *)0);

      fp = *((argile_file_t * *)&((argile_list_t *)lx)->data);
      for (u = ((argile).main)->upper; (u); u = (u)->upper) {
        if (((u)->ghost == (fp)->code)) {
          argile_list_prepend(&p, argile_list_new((fp)->path, ((argile_deleter_t)0)));
          break;
        } //;
      };
    };
    lp = p;
    for (; (lp); lp = ((argile_list_t *)lp)->next) {
      fprintf(f, "use \"%s\"%s", *((char * *)&((argile_list_t *)lp)->data), new_line);
    };
    argile_list_del(p);
  };
  if ((((argile).main)->calls)) {
    c = *((argile_call_t * *)&((argile_list_t *)((argile).main)->calls)->data);
  } //;
  else {
    c = ((argile_call_t *)0);
  };
  duse = argile_find_def("std", "use", "", 1);
  dinc = argile_find_def("std", "use", "include", 1);
  dvar = argile_find_def("std", "extdef", "", 1);
  dfunc = argile_find_def("std", "extdef", "func", 1);
  dext = argile_find_def("std", "extern", "", 1);
  dnodecl = argile_find_def("std", "extern", "nodecl", 1);
  dtref = argile_find_def("std", "typeref", "", 1);
  dtraw = argile_find_def("std", "typeraw", "", 1);
  if (((duse) && ((dinc) && ((dvar) && ((dfunc) && ((dext) && ((dnodecl) && ((dtref) && (dtraw))))))))) {
    argile_list_t * lx;

    lx = ((argile).main)->defs;
    for (; (lx); lx = ((argile_list_t *)lx)->next) {
      argile_def_t * d = ((argile_def_t *)0);

      d = *((argile_def_t * *)&((argile_list_t *)lx)->data);
      if (((d)->locall || (d)->private)) {
        continue;
      } //;
      if (((d)->dtype == ARGILE_DEF_VAR)) {
        argile_buff_flush(&t_2);
        argile_type_call_string((d)->type, ((((d)->maker)) ? ((d)->maker) : (c)), &t_2);
        if ((((((int)(d)->type) >> 30) & 1))) {
          argile_buff_flush(&s);
          argile_syntax_module_call((dtraw)->syntax, &t_2, (char *)0, ((argile_list_t *)0), &s);
          argile_buff_flush(&t_2);
          argile_buff_cat(&t_2, &s);
        } //;
        argile_buff_flush(&s);
        if (((d)->ext)) {
          argile_syntax_module_call((((d)->nodecl) ? ((dnodecl)->syntax) : ((dext)->syntax)), &t_2, argile_def_gen_id(d), ((argile_list_t *)0), &s);
        } //;
        else {
          argile_syntax_module_call((dvar)->syntax, &t_2, argile_def_gen_id(d), (d)->syntax, &s);
        };
        if (((s).ptr)) {
          if ((((d)->maker) && (((d)->maker)->comment))) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          } //;
          fwrite((s).ptr, (s).len, 1, f);
        } //;
        fputs(new_line, f);
      } //;
      else if ((((d)->dtype == ARGILE_DEF_FUNC) && !((argile_def_is_macro(d))))) {
        argile_buff_flush(&t_2);
        argile_type_call_string((d)->type, ((((d)->maker)) ? ((d)->maker) : (c)), &t_2);
        if ((((((int)(d)->type) >> 31) & 1))) {
          argile_buff_flush(&s);
          argile_syntax_module_call((dtref)->syntax, &t_2, (char *)0, ((argile_list_t *)0), &s);
          argile_buff_flush(&t_2);
          argile_buff_cat(&t_2, &s);
        } //;
        else if ((((((int)(d)->type) >> 30) & 1))) {
          argile_buff_flush(&s);
          argile_syntax_module_call((dtraw)->syntax, &t_2, (char *)0, ((argile_list_t *)0), &s);
          argile_buff_flush(&t_2);
          argile_buff_cat(&t_2, &s);
        } //;
        argile_buff_flush(&s);
        if (((d)->ext)) {
          argile_syntax_module_call((((d)->nodecl) ? ((dnodecl)->syntax) : ((dext)->syntax)), &t_2, (char *)0, (d)->syntax, &s);
        } //;
        else {
          argile_syntax_module_call((dfunc)->syntax, &t_2, argile_def_gen_id(d), (d)->syntax, &s);
        };
        if (((s).ptr)) {
          if ((((d)->maker) && (((d)->maker)->comment))) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          } //;
          fwrite((s).ptr, (s).len, 1, f);
        } //;
        fputs(new_line, f);
      } //;
      else if (((d)->maker)) {
        argile_buff_flush(&s);
        argile_call_string((d)->maker, 0, &s);
        if (((s).ptr)) {
          if ((((d)->maker)->comment)) {
            fprintf(f, "(:%s:)\n", ((d)->maker)->comment);
          } //;
          fwrite((s).ptr, (s).len, 1, f);
        } //;
        fputs(new_line, f);
      } //;
    };
  } //;
  if (((s).ptr)) {
    argile_dbg_free((s).ptr);
  } //;
  if (((t_2).ptr)) {
    argile_dbg_free((t_2).ptr);
  } //;
  (argile).use_colors = old;
}

void argile_printf(char * fmt, ...)
/** :argile_printf <text fmt> [...]: -> nothing **/
{
  va_list args;
  int max = 0;

  va_start(args, fmt);
  max = vsnprintf((char *)0, 0, fmt, args);
  va_end(args);
  if (((max)++ > 0)) {
    char * string = "";
    int len = 0;

    string = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt);
    len = vsnprintf(string, max, fmt, args);
    va_end(args);
    if ((len < max)) {
      argile_output(string, len);
    } //;
    else {
      argile_output(string, max);
    };
    argile_dbg_free(string);
  } //;
}

void argile_die(char * fmt_2, ...)
/** :argile_die <text fmt> [...]: -> nothing **/
{
  va_list args;
  int max = 0;

  if (((argile).error)) {
    return;
  } //;
  va_start(args, fmt_2);
  max = vsnprintf((char *)0, 0, fmt_2, args);
  va_end(args);
  if (((max)++ > 0)) {
    int len = 0;

    if (((argile).linebuff)) {
      max += ((((argile).linebuff)->len * 2) + 64);
    } //;
    (argile).error = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt_2);
    len = vsnprintf((argile).error, max, fmt_2, args);
    va_end(args);
    if (((argile).linebuff)) {
      print_line((((argile).error) + len), (max - len));
    } //;
  } //;
}

static void print_line(char * dst, int len)
/** :print line <text dst> <int len>: -> nothing **/
{
  int ofs = 0;
  int i_2 = 0;

  if (((argile).linebuff == NULL)) {
    return;
  } //;
  argile_buff_putc((argile).linebuff, '\0');
  ofs = snprintf(dst, len, "\n%s\n", ((argile).linebuff)->ptr);
  argile_buff_seek((argile).linebuff, (-1));
  if (((((argile).loc).start).row == (((argile).loc).end).row)) {
    while ((i_2 < (((argile).loc).start).col)) {
      ofs += snprintf(((dst) + ofs), (len - ofs), "-");
      (i_2)++;
    };
  } //;
  if ((i_2 < (((argile).loc).end).col)) {
    while ((i_2 < (((argile).loc).end).col)) {
      ofs += snprintf(((dst) + ofs), (len - ofs), "^");
      (i_2)++;
    };
  } //;
  else {
    ofs += snprintf(((dst) + ofs), (len - ofs), "^");
  };
  snprintf(((dst) + ofs), (len - ofs), "-> at \"%s\", line %d", ((((argile).input_name)) ? ((argile).input_name) : ("anonymous input")), (((argile).loc).end).row);
}

void argile_die_again(char * fmt_3, ...)
/** :argile_die_again <text fmt> [...]: -> nothing **/
{
  char * old_death = "";
  va_list args;
  int max = 0;

  old_death = (argile).error;
  va_start(args, fmt_3);
  max = vsnprintf((char *)0, 0, fmt_3, args);
  va_end(args);
  if (((max)++ > 0)) {
    int len_2 = 0;

    if (((argile).linebuff)) {
      max += ((((argile).linebuff)->len * 2) + 32);
    } //;
    (argile).error = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt_3);
    len_2 = vsnprintf((argile).error, max, fmt_3, args);
    va_end(args);
    if (((argile).linebuff)) {
      print_line((((argile).error) + len_2), (max - len_2));
    } //;
  } //;
  if (!((old_death == NULL))) {
    argile_dbg_free(old_death);
  } //;
}

void argile_die_hard(char * fmt_4, ...)
/** :argile_die_hard <text fmt> [...]: -> nothing **/
{
  va_list args;

  fprintf(stderr, "\n");
  va_start(args, fmt_4);
  vfprintf(stderr, fmt_4, args);
  va_end(args);
  if ((((argile).linebuff) && (((argile).linebuff)->len != 0))) {
    int len_2 = 0;
    char * tmp = "";

    len_2 = ((((argile).linebuff)->len * 2) + 32);
    tmp = ((char *)argile_dbg_malloc(len_2));
    print_line(tmp, len_2);
    fprintf(stderr, "%s\n", tmp);
    argile_dbg_free(tmp);
  } //;
  {
    fprintf(stderr, "\n");
    exit(1);
  };
}

void argile_die_at(argile_call_t * at, char * fmt_5, ...)
/** :argile_die_at <call at> <text fmt> [...]: -> nothing **/
{
  va_list args;
  int max = 0;
  argile_buff_t buf = ((argile_buff_t){0});

  if (((argile).error)) {
    return;
  } //;
  va_start(args, fmt_5);
  max = vsnprintf((char *)0, 0, fmt_5, args);
  va_end(args);
  if (((max)++ > 0)) {
    int len_2 = 0;

    argile_buff_puts(&buf, "\n  ");
    if (((at)->owner)) {
      argile_buff_putc(&buf, *&("(")[0]);
    } //;
    argile_call_string(at, 1, &buf);
    if (((at)->owner)) {
      argile_buff_putc(&buf, *&(")")[0]);
    } //;
    if ((((at)->context != ARGILE_TYPE_NOTHING) && ((at)->context != ARGILE_TYPE_ANYTHING))) {
      argile_buff_puts(&buf, "\n(expected return type: ");
      argile_typename((at)->context, &buf, (at)->scope);
      argile_buff_puts(&buf, ")");
    } //;
    argile_buff_puts(&buf, "\n=> at \"");
    if ((((at)->scope)->input)) {
      argile_buff_puts(&buf, ((at)->scope)->input);
    } //;
    else {
      argile_buff_puts(&buf, "anonymous input");
    };
    argile_buff_puts(&buf, "\", from line ");
    argile_buff_putn(&buf, (((at)->loc).start).row);
    argile_buff_puts(&buf, " column ");
    argile_buff_putn(&buf, (((at)->loc).start).col);
    argile_buff_puts(&buf, ", to line ");
    argile_buff_putn(&buf, (((at)->loc).end).row);
    argile_buff_puts(&buf, " column ");
    argile_buff_putn(&buf, (((at)->loc).end).col);
    argile_buff_putc(&buf, '\0');
    max += (buf).len;
    (argile).error = ((char *)argile_dbg_malloc(max));
    va_start(args, fmt_5);
    len_2 = vsnprintf((argile).error, max, fmt_5, args);
    snprintf((((argile).error) + len_2), (max - len_2), "%s", (buf).ptr);
    va_end(args);
    argile_dbg_free((buf).ptr);
    (argile).killer = at;
  } //;
}

void argile_resurrect()
/** :argile_resurrect: -> nothing **/
{
  if (((argile).error)) {
    argile_dbg_free((argile).error);
    (argile).error = (char *)0;
  } //;
}

void argile_def(argile_list_t * syntax, int del_syntax, argile_type_t type, argile_def_type_t dtype, void * dval)
/** :argile_def <list of (argile syntax) syntax> <int del_syntax> <argile type type> <def type dtype> <any dval>: -> nothing **/
{
  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argile_list_t *)0));
  } //;
  argile_code_def((argile).main, argile_def_new(syntax, del_syntax, type, ((argile_call_t *)0), dtype, dval), 1);
}

void argile_bind(char * synstr, char * modname, char * name_2)
/** :argile_bind <text synstr> <text modname> <text name>: -> nothing **/
{
  argile_list_t * syn;
  unsigned char comp;
  argile_module_t * mod = ((argile_module_t *)0);
  argile_bind_t * bind = ((argile_bind_t *)0);

  if (((argile).error)) {
    return;
  } //;
  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argile_list_t *)0));
  } //;
  if (((((syn = argile_syntax_parse(synstr)) && (comp = (argile_syntax_compile_params(syn, (argile).main, ((argile_call_t *)0))))) && (mod = argile_getmod(modname))) && (bind = argile_module_getbind(mod, name_2)))) {
    argile_type_t type_2;

    type_2 = ((((bind)->type)) ? (*(bind)->type) : (ARGILE_TYPE_NOTHING));
    if ((bind)->deftype) {
      if (((bind)->gettype)) {
        type_2 = (*(bind)->gettype)(NULL);
      } //;
      argile_def(syn, 1, (argile_type_t)ARGILE_TYPE_TYPE, ARGILE_DEF_TYPE, ((void *)((long)type_2)));
    } //;
    else {
      argile_def(syn, 1, type_2, ARGILE_DEF_BIND, bind);
    };
  } //;
  else if ((syn)) {
    if (!(comp)) {
      argile_die("binding: %s some parameter type could not compile", synstr);
    } //;
    else if ((mod == NULL)) {
      argile_die("binding: %s: no such module", modname);
    } //;
    else if ((bind == NULL)) {
      argile_die("binding: %s: no such binding in module %s", name_2, modname);
    } //;
    argile_list_del(syn);
  } //;
}

void argile_deftype(char * synstr_2, argile_type_t t_2)
/** :argile_deftype <text synstr> <argile type t>: -> nothing **/
{
  argile_list_t * syn;

  if (!(((argile).main))) {
    (argile).main = argile_code_new(((argile_code_t *)0), ((argile_list_t *)0));
  } //;
  syn = argile_syntax_parse(synstr_2);
  if (((syn) && (argile_syntax_compile_params(syn, (argile).main, ((argile_call_t *)0))))) {
    argile_def(syn, 1, (argile_type_t)ARGILE_TYPE_TYPE, ARGILE_DEF_TYPE, ((void *)((long)t_2)));
  } //;
  else if ((syn)) {
    argile_die("type definition: %s some parameter type did not compile", synstr_2);
    argile_list_del(syn);
  } //;
}

void argile_implicitize()
/** :argile_implicitize: -> nothing **/
{
  argile_list_t * ldef;

  if (((argile).main == NULL)) {
    return;
  } //;
  for (ldef = ((argile).main)->defs; (ldef); ldef = ((argile_list_t *)ldef)->next) {
    (*((argile_def_t * *)&((argile_list_t *)ldef)->data))->implicit = 1;
  };
  ((argile).main)->has_weak_defs = 1;
  ((argile).stat).binds = 0;
  ((argile).stat).num_match_try = 0;
}

int argile_typename(argile_type_t type_2, argile_buff_t * buf, argile_code_t * scope)
/** :argile_typename <argile type type> <buff buf> <argile code scope>: -> int **/
{
  argile_buff_t tmp = ((argile_buff_t){0});
  argile_def_t * dtyperef = ((argile_def_t *)0);
  argile_def_t * dtyperaw = ((argile_def_t *)0);
  argile_type_info_t * info = ((argile_type_info_t *)0);
  argile_list_t * cur;
  argile_list_t * prev;
  argile_list_t * next;

  dtyperef = argile_find_def("std", "typeref", "", 0);
  dtyperaw = argile_find_def("std", "typeraw", "", 0);
  info = argile_type_get_info(type_2);
  if (((info) && ((info)->ttype == ARGILE_TYPE_KIND_CTYPE))) {
    if (((((info)->tval).t_ctype).generator)) {
      unsigned char old;

      old = (argile).skip_codes;
      (argile).skip_codes = 1;
      argile_buff_flush(&tmp);
      argile_call_string((((info)->tval).t_ctype).generator, 0, &tmp);
      (argile).skip_codes = old;
      if ((((((int)type_2) >> 31) & 1))) {
        write_ref_or_raw_in_with(&tmp, buf, dtyperef, "reference");
      } //;
      else if ((((((int)type_2) >> 30) & 1))) {
        write_ref_or_raw_in_with(&tmp, buf, dtyperaw, "structure");
      } //;
      else {
        argile_buff_cat(buf, &tmp);
      };
      if (((tmp).ptr)) {
        argile_dbg_free((tmp).ptr);
      } //;
      return 1;
    } //;
  } //;
  argile_code_getdef(scope, ((argile_call_t *)0), &prev, &next);
  while ((cur = argile_code_nextdef(&scope, &prev, &next))) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argile_list_t *)cur)->data);
    if ((((d)->dtype != ARGILE_DEF_TYPE) || ((d)->type != ARGILE_TYPE_TYPE))) {
      continue;
    } //;
    if ((((d)->dval).type == (((int)type_2) & ((1 << 30) - 1)))) {
      if ((((((int)type_2) >> 31) & 1))) {
        argile_buff_flush(&tmp);
        argile_syntax_string((d)->syntax, &tmp);
        write_ref_or_raw_in_with(&tmp, buf, dtyperef, "reference");
      } //;
      else if ((((((int)type_2) >> 30) & 1))) {
        argile_buff_flush(&tmp);
        argile_syntax_string((d)->syntax, &tmp);
        write_ref_or_raw_in_with(&tmp, buf, dtyperaw, "structure");
      } //;
      else {
        argile_syntax_string((d)->syntax, buf);
      };
      if (((tmp).ptr)) {
        argile_dbg_free((tmp).ptr);
      } //;
      return 1;
    } //;
  };
  argile_buff_putn(buf, ((int)type_2));
  return 0;
}

argile_module_t * argile_getmod(char * name_3)
/** :argile_getmod <text name>: -> (argile) module **/
{
  argile_list_t * lmod;

  for (lmod = (argile).mods; (lmod); lmod = ((argile_list_t *)lmod)->next) {
    argile_module_t * mod = ((argile_module_t *)0);

    mod = *((argile_module_t * *)&((argile_list_t *)lmod)->data);
    if ((strcmp(name_3, (mod)->name) == 0)) {
      return mod;
    } //;
  };
  return ((argile_module_t *)0);
}

void argile_addmod(argile_module_t * mod)
/** :argile_addmod <module mod>: -> nothing **/
{
  argile_list_prepend(&(argile).mods, argile_list_new(mod, (void *)&argile_module_del));
}

static int ends_by(char * str, int n, char * end)
/** :<text str> ends by <int n> <text end>: -> int **/
{
  int e = 0;

  e = strlen(end);
  if (((n > e) && (strcmp(((str) + (n - e)), end) == 0))) {
    return e;
  } //;
  return 0;
}

void argile_init_std()
/** :argile_init_std: -> nothing **/
{
  argile_module_t * std = ((argile_module_t *)0);

  std = argile_module_new("std");
  argmod_init_binds(std);
  argile_addmod(std);
}

argile_file_t * argile_getfile(argile_file_t * p_argile_file)
/** :argile_getfile <file>: -> (argile) file **/
{
  argile_list_t * lf;

  lf = argile_list_search((argile).used, p_argile_file, (void *)&argile_file_eq);
  if ((lf == NULL)) {
    return ((argile_file_t *)0);
  } //;
  return *((argile_file_t * *)&((argile_list_t *)lf)->data);
}

argile_file_t * argile_getfile_by_name(char * name_4)
/** :argile_getfile_by_name <text name>: -> (argile) file **/
{
  argile_list_t * lf;

  lf = argile_list_search((argile).used, name_4, (void *)&argile_filename_eq);
  if ((lf == NULL)) {
    return ((argile_file_t *)0);
  } //;
  return *((argile_file_t * *)&((argile_list_t *)lf)->data);
}

void argile_addfile(argile_file_t * p_argile_file_2)
/** :argile_addfile <file>: -> nothing **/
{
  argile_list_prepend(&(argile).used, argile_list_new(p_argile_file_2, (void *)&argile_file_del));
}

argile_file_t * argile_loadfile(char * path)
/** :argile_loadfile <text path>: -> (argile) file **/
{
  argile_file_t * file = ((argile_file_t *)0);
  argile_file_t * old = ((argile_file_t *)0);

  if ((argile).verbose) {
    {
      int i = 0;

      for (i = 0; ((i <= ((argile).depth - 1))); (i)++) {
        fprintf(stderr, " ");
      };
    };
    fprintf(stderr, "   loading file %s\n", path);
  } //;
  file = argile_getfile_by_name(path);
  if (!((file == NULL))) {
    return file;
  } //;
  file = try_new_file(path);
  if ((file == NULL)) {
    argile_die("include file: %s: could not find file", path);
    return ((argile_file_t *)0);
  } //;
  if (((file)->error != 0)) {
    argile_die("%s: %s", path, strerror((file)->error));
    argile_file_del(file);
    return ((argile_file_t *)0);
  } //;
  old = argile_getfile(file);
  if ((old)) {
    argile_file_del(file);
    add_include((old)->path);
    return old;
  } //;
  argile_addfile(file);
  argile_file_load(file);
  if (((argile).error)) {
    argile_list_t * lf;

    lf = (argile).used;
    argile_list_rm(&(argile).used, lf);
    ((argile_list_t *)lf)->next = ((argile_list_t *)0);
    argile_list_del(lf);
    return ((argile_file_t *)0);
  } //;
  add_include((file)->path);
  if ((argile).verbose) {
    {
      int i = 0;

      for (i = 0; ((i <= ((argile).depth - 1))); (i)++) {
        fprintf(stderr, " ");
      };
    };
    fprintf(stderr, "   loaded  file %s\n", (file)->path);
  } //;
  return file;
}

static argile_file_t * try_new_file(char * path_2)
/** :try new file <text path>: -> (argile) file **/
{
  char * base = (char *)0;
  int baselen = 0;
  argile_list_t * lf;
  int extlen = 0;
  int libextlen = 0;
  int pathlen = 0;
  argile_file_t * file = ((argile_file_t *)0);
  argile_list_t * lp;

  if ((*&(path_2)[0] == '/')) {
    return argile_file_new(path_2, ((struct stat *)0));
  } //;
  lf = (argile).used;
  for (; (lf); lf = ((argile_list_t *)lf)->next) {
    if (((*((argile_file_t * *)&((argile_list_t *)lf)->data))->code == (argile).main)) {
      base = (*((argile_file_t * *)&((argile_list_t *)lf)->data))->path;
    } //;
  };
  if ((base)) {
    char * b = "";

    b = strrchr(base, '/');
    if ((b)) {
      baselen = ((b) - base);
    } //;
    else {
      base = ".";
      baselen = 1;
    };
  } //;
  extlen = strlen(".arg");
  libextlen = strlen(".argl");
  if ((libextlen > extlen)) {
    extlen = libextlen;
  } //;
  pathlen = (((1 + strlen(path_2)) + extlen) + 1);
  if (((base) && (file = try_in_dir(path_2, pathlen, base, baselen)))) {
    return file;
  } //;
  lp = (argile).file_path;
  for (; (lp); lp = ((argile_list_t *)lp)->next) {
    char * dirpath = "";
    int dirlen = 0;

    dirpath = *((char * *)&((argile_list_t *)lp)->data);
    dirlen = strlen(dirpath);
    file = try_in_dir(path_2, pathlen, dirpath, dirlen);
    if ((file != NULL)) {
      return file;
    } //;
  };
  return ((argile_file_t *)0);
}

void argile_push_output(argile_inout_t output, void * output_data)
/** :argile_push_output <inout output> <any output_data>: -> nothing **/
{
  void *(* ptrs);

  ptrs = ((void *(*))argile_dbg_malloc((5 * sizeof(void *))));
  *&(ptrs)[0] = (argile).output;
  *&(ptrs)[1] = (argile).output_data;
  *&(ptrs)[2] = (argile).output_name;
  *&(ptrs)[3] = ((void *)((long)(argile).output_line));
  *&(ptrs)[4] = ((void *)((long)(argile).refcount));
  argile_list_prepend(&(argile).outctx, argile_list_new(ptrs, (void *)&argile_dbg_free));
  (argile).output = output;
  (argile).output_data = output_data;
  (argile).output_line = 1;
  (argile).refcount = 0;
}

void argile_pop_output()
/** :argile_pop_output: -> nothing **/
{
  argile_list_t * h;
  void *(* p);

  if (((argile).refcount != 0)) {
    argile_flush_refs();
  } //;
  h = argile_list_pop(&(argile).outctx);
  p = ((void *(*))*((void * *)&((argile_list_t *)h)->data.u_anything));
  (argile).output = ((argile_inout_t)(p)[0]);
  (argile).output_data = (p)[1];
  (argile).output_name = ((char *)(p)[2]);
  (argile).output_line = ((int)((long)(p)[3]));
  (argile).refcount = ((int)((long)(p)[4]));
  argile_list_del(h);
}

void argile_push_color(argile_buff_t * out, char * color)
/** :argile_push_color <buff out> <text color>: -> nothing **/
{
  if ((((argile).colors == NULL) || (strcmp(color, *((char * *)&((argile_list_t *)(argile).colors)->data)) != 0))) {
    if ((argile).use_colors) {
      argile_buff_puts(out, color);
    } //;
    if ((argile).daltonism) {
      argile_buff_puts(out, convert_to_daltonism(color));
    } //;
  } //;
  argile_list_prepend(&(argile).colors, argile_list_new(color, ((argile_deleter_t)0)));
}

static char * convert_to_daltonism(char * colour)
/** :convert <text colour> to daltonism: -> text **/
{
  if ((strcmp(colour, "\x1b[1;32m") == 0)) {
    return "(:O:)";
  } //;
  if ((strcmp(colour, "\x1b[1;31m") == 0)) {
    return "(:E:)";
  } //;
  if ((strcmp(colour, "\x1b[1;33m") == 0)) {
    return "(:R:)";
  } //;
  if ((strcmp(colour, "\x1b[2;32m") == 0)) {
    return "(:W:)";
  } //;
  if ((strcmp(colour, "\x1b[0;1m") == 0)) {
    return "(:U:)";
  } //;
  return "";
}

void argile_pop_color(argile_buff_t * out_2)
/** :argile_pop_color <buff out>: -> nothing **/
{
  argile_list_t * head;

  head = argile_list_pop(&(argile).colors);
  if (((argile).colors)) {
    char * cur = "";

    cur = *((char * *)&((argile_list_t *)(argile).colors)->data);
    if (((strcmp(cur, *((char * *)&((argile_list_t *)head)->data)) != 0) && (argile).use_colors)) {
      argile_buff_puts(out_2, cur);
    } //;
    if ((argile).daltonism) {
      argile_buff_puts(out_2, convert_to_daltonism(cur));
    } //;
  } //;
  else if ((argile).use_colors) {
    argile_buff_puts(out_2, "\x1b[0m");
  } //;
  argile_list_del(head);
}

void argile_push_token(int tok)
/** :argile_push_token <int tok>: -> nothing **/
{
  argile_list_append(&(argile).last_token, argile_list_new(((void *)((long)tok)), ((argile_deleter_t)0)));
  if (((argile).tokens == NULL)) {
    (argile).tokens = (argile).last_token;
  } //;
}

int argile_pop_token()
/** :argile_pop_token: -> int **/
{
  argile_list_t * lt;
  int t_3 = 0;

  if (((argile).tokens == NULL)) {
    return 0;
  } //;
  lt = argile_list_pop(&(argile).tokens);
  if (((argile).tokens == NULL)) {
    (argile).last_token = ((argile_list_t *)0);
  } //;
  t_3 = *((int *)&((argile_list_t *)lt)->data.u_int);
  argile_list_del(lt);
  return t_3;
}

void argile_push_optoken(int token)
/** :argile_push_optoken <int token>: -> nothing **/
{
  argile_list_append(&(argile).last_optoken, argile_list_new(((void *)((long)token)), ((argile_deleter_t)0)));
  if (((argile).ops_tokens == NULL)) {
    (argile).ops_tokens = (argile).last_optoken;
  } //;
}

int argile_pop_optoken()
/** :argile_pop_optoken: -> int **/
{
  argile_list_t * lt;
  int t_3 = 0;

  if (((argile).ops_tokens == NULL)) {
    return 0;
  } //;
  lt = argile_list_pop(&(argile).ops_tokens);
  if (((argile).ops_tokens == NULL)) {
    (argile).last_optoken = ((argile_list_t *)0);
  } //;
  t_3 = *((int *)&((argile_list_t *)lt)->data.u_int);
  argile_list_del(lt);
  return t_3;
}

void argile_push_op(char * op)
/** :argile_push_op <text op>: -> nothing **/
{
  argile_list_append(&(argile).last_op, argile_list_new(op, ((argile_deleter_t)0)));
  if (((argile).ops == NULL)) {
    (argile).ops = (argile).last_op;
  } //;
}

char * argile_pop_op()
/** :argile_pop_op: -> text **/
{
  argile_list_t * lv;
  char * val = "";

  if (((argile).ops == NULL)) {
    return (char *)0;
  } //;
  lv = argile_list_pop(&(argile).ops);
  if (((argile).ops == NULL)) {
    (argile).last_op = ((argile_list_t *)0);
  } //;
  val = *((char * *)&((argile_list_t *)lv)->data);
  argile_list_del(lv);
  return val;
}

void argile_push_indent(int indent)
/** :argile_push_indent <int indent>: -> nothing **/
{
  if (((indent > -1) && (indent == argile_top_indent()))) {
    return;
  } //;
  argile_list_prepend(&(argile).indents, argile_list_new(((void *)((long)indent)), ((argile_deleter_t)0)));
}

int argile_top_indent()
/** :argile_top_indent: -> int **/
{
  if (((argile).indents == NULL)) {
    return -2;
  } //;
  return *((int *)&((argile_list_t *)(argile).indents)->data.u_int);
}

int argile_pop_indent()
/** :argile_pop_indent: -> int **/
{
  argile_list_t * ltop;
  int top = 0;

  if (((argile).indents == NULL)) {
    return -2;
  } //;
  ltop = argile_list_pop(&(argile).indents);
  top = *((int *)&((argile_list_t *)ltop)->data.u_int);
  argile_list_del(ltop);
  return top;
}

int argile_yyinput(char * buf_2, int len_2)
/** :argile_yyinput <text buf> <int len>: -> int **/
{
  if (((argile).input_ended || ((argile).input == NULL))) {
    return 0;
  } //;
  return (*(argile).input)((argile).input_data, buf_2, len_2);
}

int argile_yylex_wrapper()
/** :argile_yylex_wrapper: -> int **/
{
  if (((argile).error)) {
    return 0;
  } //;
  if (((argile).tokens)) {
    return argile_pop_token();
  } //;
  if (((argile).ops_tokens)) {
    *&argile_yylval.string = argile_pop_op();
    return argile_pop_optoken();
  } //;
  if ((argile).input_ended) {
    return 0;
  } //;
  return argile_yylex();
}

void argile_add_leak(void * data_2)
/** :argile_add_leak <any data>: -> nothing **/
{
  argile_list_prepend(&(argile).leaks, argile_list_new(data_2, (void *)&argile_dbg_free));
}

void argile_rm_leak(void * data_3)
/** :argile_rm_leak <any data>: -> nothing **/
{
  argile_list_t * found;

  found = argile_list_search((argile).leaks, data_3, ((argile_comparer_t)0));
  if ((found)) {
    argile_list_rm(&(argile).leaks, found);
    ((argile_list_t *)found)->del = NULL;
    argile_list_del(found);
  } //;
}

void argile_choke_leaks()
/** :argile_choke_leaks: -> nothing **/
{
  argile_list_del((argile).leaks);
  (argile).leaks = ((argile_list_t *)0);
}

void argile_forget_leaks()
/** :argile_forget_leaks: -> nothing **/
{
  argile_list_t * ll;
  argile_list_t * nx;

  for (ll = (argile).leaks; (ll); ll = nx) {
    nx = ((argile_list_t *)ll)->next;
    argile_dbg_free(ll);
  };
  (argile).leaks = ((argile_list_t *)0);
}

void argile_gen_ref(argile_type_t context, argile_type_t type_3)
/** :argile_gen_ref <argile type context> <argile type type>: -> nothing **/
{
  unsigned char is_ref;
  unsigned char is_raw;
  unsigned char in_ref;
  unsigned char in_raw;

  is_ref = (((((int)type_3) >> 31) & 1));
  is_raw = (((((int)type_3) >> 30) & 1));
  in_ref = (((((int)context) >> 31) & 1));
  in_raw = (((((int)context) >> 30) & 1));
  if ((in_ref && !(is_ref))) {
    argile_ref(-1);
  } //;
  if ((is_ref && !(in_ref))) {
    argile_ref(1);
  } //;
  if ((in_raw && !(is_raw))) {
    argile_ref(1);
  } //;
  if ((is_raw && !(in_raw))) {
    argile_ref(-1);
  } //;
}

void argile_ref(int count)
/** :argile_ref <int count>: -> nothing **/
{
  (argile).refcount += count;
}

void argile_flush_refs()
/** :argile_flush_refs: -> nothing **/
{
  if (((argile).refcount < 0)) {
    while ((((argile).refcount)++ != 0)) {
      (*(argile).output)((argile).output_data, "&", 1);
    };
  } //;
  else if (((argile).refcount > 0)) {
    while ((((argile).refcount)-- != 0)) {
      (*(argile).output)((argile).output_data, "*", 1);
    };
  } //;
  (argile).refcount = 0;
}

void argile_output(char * buf_3, int len_3)
/** :argile_output <text buf> <int len>: -> nothing **/
{
  if (((((argile).gen_lines != 0) && ((argile).outctx == NULL)) && (((argile).next_input_buff)->len > 0))) {
    unsigned int n_2 = 0;

    n_2 = ((argile).next_input_buff)->len;
    ((argile).next_input_buff)->len = 0;
    argile_output(((argile).next_input_buff)->ptr, ((int)n_2));
    ((argile).last_input_line)--;
  } //;
  if ((len_3 > 0)) {
    int i_2 = 0;

    argile_flush_refs();
    for (i_2 = 0; ((i_2 <= (len_3 - 1))); (i_2)++) {
      if ((*&(buf_3)[i_2] == '\n')) {
        ((argile).output_line)++;
        ((argile).last_input_line)++;
      } //;
    };
    (*(argile).output)((argile).output_data, buf_3, len_3);
  } //;
}

void argile_puts(char * s)
/** :argile_puts <text s>: -> nothing **/
{
  if ((*&(s)[0] != 0)) {
    argile_output(s, strlen(s));
  } //;
}

void argile_putn(int n_2)
/** :argile_putn <int n>: -> nothing **/
{
  char( s_2[16]);

  n_2 = snprintf(((char *)s_2), sizeof(s_2), "%d", n_2);
  if (((n_2 > 0) && (n_2 < sizeof(s_2)))) {
    argile_output(((char *)s_2), n_2);
  } //;
}

void argile_indent()
/** :argile_indent: -> nothing **/
{
  int i_2 = 0;

  for (i_2 = 0; (i_2 < (argile).indent); (i_2)++) {
    argile_puts("  ");
  };
}

unsigned int argile_hash(char * t_3)
/** :argile_hash <text t>: -> nat **/
{
  unsigned int h = 0;

  while ((*&(t_3)[0] != 0)) {
    h += ((unsigned int)*&((t_3)++)[0]);
    h += (h << 10);
    h ^= (h >> 6);
  };
  h += (h << 3);
  h ^= (h >> 11);
  h += (h << 15);
  return h;
}

int argile_streq(void * a, void * b)
/** :argile_streq <any a> <any b>: -> int **/
{
  return ((int)(strcmp(((char *)a), ((char *)b)) == 0));
}

void argile_check_collisions(argile_buff_t * ident_buff)
/** :argile_check_collisions <buff ident_buff>: -> nothing **/
{
  int num = 2;
  int end_2 = 0;
  unsigned int id = 0;

  end_2 = id_end_num((ident_buff)->ptr, (ident_buff)->len, &num);
  id = (argile_hash((ident_buff)->ptr) % 1024);
  while ((argile_list_search(((argile).ids)[id], (ident_buff)->ptr, (void *)&argile_streq))) {
    (ident_buff)->len = ((unsigned int)end_2);
    argile_buff_putc(ident_buff, '_');
    argile_buff_putn(ident_buff, (num)++);
    argile_buff_putc(ident_buff, '\0');
    id = (argile_hash((ident_buff)->ptr) % 1024);
  };
  argile_list_prepend(&((argile).ids)[id], argile_list_new(argile_dbg_strdup((ident_buff)->ptr), (void *)&argile_dbg_free));
}

void argile_check_local_collisions(argile_buff_t * ident_buff_2, argile_code_t * code)
/** :argile_check_local_collisions <buff ident_buff> <argile code code>: -> nothing **/
{
  int min = -1;
  int max = 1;
  unsigned char found;
  int num = 1;
  unsigned int h = 0;

  found = 0;
  while ((code)) {
    argile_list_t * ld;

    for (ld = (code)->defs; (ld); ld = ((argile_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);
      char * id = "";

      d = ((argile_def_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything));
      if ((d)->locall) {
        continue;
      } //;
      id = (d)->genid;
      if (((id == NULL) && ((d)->param != NULL))) {
        id = ((d)->param)->genid;
      } //;
      check_id_num(ident_buff_2, id, &found, &min, &max);
    };
    for (ld = (code)->special_ids; (ld); ld = ((argile_list_t *)ld)->next) {
      check_id_num(ident_buff_2, ((char *)*((void * *)&((argile_list_t *)ld)->data.u_anything)), &found, &min, &max);
    };
    for (ld = (code)->calls; (ld); ld = ((argile_list_t *)ld)->next) {
      check_call_id_num(((argile_call_t *)*((void * *)&((argile_list_t *)ld)->data.u_anything)), ident_buff_2, &found, &min, &max);
    };
    code = (code)->upper;
  };
  ((ident_buff_2)->len)--;
  h = (argile_hash((ident_buff_2)->ptr) % 1024);
  while ((argile_list_search(((argile).ids)[h], (ident_buff_2)->ptr, (void *)&argile_streq))) {
    unsigned int end_2 = 0;

    found = 1;
    if ((num > max)) {
      max = num;
    } //;
    if (((min < 0) || (num < min))) {
      min = num;
    } //;
    end_2 = (ident_buff_2)->len;
    argile_buff_putc(ident_buff_2, '_');
    argile_buff_putn(ident_buff_2, ++(num));
    argile_buff_putc(ident_buff_2, '\0');
    (ident_buff_2)->len = end_2;
    h = (argile_hash((ident_buff_2)->ptr) % 1024);
  };
  argile_buff_putc(ident_buff_2, '\0');
  if (found) {
    ((ident_buff_2)->len)--;
    argile_buff_putc(ident_buff_2, '_');
    if ((min > 2)) {
      argile_buff_putn(ident_buff_2, (min - 1));
    } //;
    else {
      argile_buff_putn(ident_buff_2, (max + 1));
    };
    argile_buff_putc(ident_buff_2, '\0');
  } //;
}

void argile_globally(argile_code_t * code_2)
/** :argile_globally <argile code code>: -> nothing **/
{
  argile_list_prepend(&(argile).globally, argile_list_new(code_2, ((argile_deleter_t)0)));
}

void argile_search_defs(char * pattern, void (* callback)(argile_def_t *))
/** :argile_search_defs <text pattern> <function (def) callback>: -> nothing **/
{
  argile_buff_t b_2 = {0};
  argile_list_t * syntax_2;

  if ((*&(pattern)[0] != *&(":")[0])) {
    argile_buff_puts(&b_2, ":");
    argile_buff_puts(&b_2, pattern);
    argile_buff_puts(&b_2, ":");
    argile_buff_putc(&b_2, '\0');
  } //;
  syntax_2 = argile_syntax_parse(((((b_2).ptr == NULL)) ? (pattern) : ((b_2).ptr)));
  if (((argile).error == NULL)) {
    search_in_with(syntax_2, (argile).main, callback);
  } //;
  argile_list_del(syntax_2);
  if (!(((b_2).ptr == NULL))) {
    argile_dbg_free((b_2).ptr);
  } //;
}

int argile_match_or_reject(argile_call_t * c, argile_match_t * m, argile_type_t t_4, char * error)
/** :argile_match_or_reject <call c> <match m> <argile type t> <text error>: -> int **/
{
  argile_type_t mt;

  if ((argile_match_type(m, t_4))) {
    return 0;
  } //;
  mt = argile_match_get_type(m);
  if (((m)->type == ARGILE_MATCH_SUBCALL)) {
    argile_call_t * s_2 = ((argile_call_t *)0);

    s_2 = ((m)->value).call;
    if (((s_2)->type == ARGILE_CALL_EXPLICIT)) {
      argile_call_uncompile_subcalls(s_2, 1);
      (s_2)->def = ((argile_def_t *)0);
      (s_2)->compiled = 0;
      if ((argile_call_compile_as(s_2, t_4))) {
        return 0;
      } //;
    } //;
  } //;
  argile_call_mismatch(c, t_4, mt, error);
  return 1;
}

int argile_split_ops(int ops_type, char * str_2, int len_4, char * * lval)
/** :argile_split_ops <int ops_type> <text str> <int len> <(text) & lval>: -> int **/
{
  unsigned char o;
  unsigned char w;
  unsigned int c_2 = 0;
  unsigned int n_3 = 1;
  int i_2 = 0;
  int li = 0;

  if (((argile).op_ranges == NULL)) {
    *lval = argile_dbg_strdup(str_2);
    argile_push_token(T_WORD);
    return argile_pop_token();
  } //;
  w = 0;
  for (i_2 = 0; ((i_2 < len_4) && (n_3 > 0)); i_2 += n_3) {
    if (((argile).encoding == NULL)) {
      c_2 = ((unsigned int)((unsigned char)*&(str_2)[i_2]));
    } //;
    else {
      c_2 = (*((argile).encoding)->charat)(((str_2) + i_2), (len_4 - i_2));
      n_3 = (*((argile).encoding)->charsize)(((str_2) + i_2), (len_4 - i_2));
    };
    o = (argile_is_operator(c_2));
    if (o) {
      if (w) {
        split_op(((str_2) + li), (i_2 - li), T_WORD);
      } //;
      split_op(((str_2) + i_2), ((int)n_3), ops_type);
      li = i_2;
    } //;
    else if (!(w)) {
      li = i_2;
    } //;
    w = !(o);
  };
  if (w) {
    split_op(((str_2) + li), (i_2 - li), T_WORD);
  } //;
  *lval = argile_pop_op();
  argile_push_token(argile_pop_optoken());
  return argile_pop_token();
}

int argile_is_operator(unsigned int ch)
/** :argile_is_operator <nat ch>: -> int **/
{
  argile_list_t * lr;

  lr = (argile).op_ranges;
  for (; (lr); lr = ((argile_list_t *)lr)->next) {
    unsigned int(* r);

    r = *((unsigned int(* *))&((argile_list_t *)lr)->data);
    if ((ch < (r)[0])) {
      return 0;
    } //;
    if ((ch <= (r)[1])) {
      return 1;
    } //;
  };
  return 0;
}

void argile_add_operators(unsigned int a_2, unsigned int b_2)
/** :argile_add_operators <nat a> <nat b>: -> nothing **/
{
  if ((b_2 == 0)) {
    b_2 = a_2;
  } //;
  if ((b_2 < a_2)) {
    unsigned int c_2 = 0;

    c_2 = a_2;
    a_2 = b_2;
    b_2 = c_2;
  } //;
  if (((argile).op_ranges)) {
    unsigned int(* r);
    argile_list_t * lr;
    argile_list_t * nr;

    for (lr = (argile).op_ranges; (lr); lr = nr) {
      r = *((unsigned int(* *))&((argile_list_t *)lr)->data);
      nr = ((argile_list_t *)lr)->next;
      if ((a_2 < (r)[0])) {
        if ((((r)[0] != 0) && (b_2 < ((r)[0] - 1)))) {
          argile_list_t * lnu;

          lnu = new_range(a_2, b_2);
          if ((((argile_list_t *)lr)->prev)) {
            argile_list_link(((argile_list_t *)lr)->prev, lnu);
          } //;
          else {
            (argile).op_ranges = lnu;
          };
          argile_list_link(lnu, lr);
          break;
        } //;
        *&(r)[0] = a_2;
        if ((b_2 <= (r)[1])) {
          break;
        } //;
        *&(r)[1] = b_2;
        if ((nr == NULL)) {
          break;
        } //;
        argile_list_rm(&(argile).op_ranges, lr);
        argile_list_del(lr);
      } //;
      else if ((a_2 <= ((r)[1] + 1))) {
        if ((b_2 <= (r)[1])) {
          break;
        } //;
        *&(r)[1] = b_2;
        if ((nr == NULL)) {
          break;
        } //;
        a_2 = (r)[0];
        argile_list_rm(&(argile).op_ranges, lr);
        argile_list_del(lr);
      } //;
    };
    if (((lr == NULL) && (a_2 > (r)[1]))) {
      argile_list_link(argile_list_end((argile).op_ranges), new_range(a_2, b_2));
    } //;
  } //;
  else {
    (argile).op_ranges = new_range(a_2, b_2);
  };
}

argile_def_t * argile_find_def(char * mod_2, char * bnd, char * opt_2, int err)
/** :argile_find_def <text mod> <text bnd> <text opt> <int err>: -> (argile) def **/
{
  argile_module_t * m_2 = ((argile_module_t *)0);
  argile_bind_t * b_3 = ((argile_bind_t *)0);
  unsigned char o;
  argile_code_t * c_2 = ((argile_code_t *)0);

  m_2 = argile_getmod(mod_2);
  if ((m_2 == NULL)) {
    if ((err != 0)) {
      argile_die("module '%s' not found", mod_2);
    } //;
    return ((argile_def_t *)0);
  } //;
  b_3 = argile_module_getbind(m_2, bnd);
  if ((b_3 == NULL)) {
    if ((err)) {
      argile_die("binding '%s' not found in module '%s'", bnd, mod_2);
    } //;
    return ((argile_def_t *)0);
  } //;
  o = 0;
  for (c_2 = (argile).main; (c_2); c_2 = (c_2)->upper) {
    argile_list_t * ld;

    ld = (c_2)->defs;
    for (; (ld); ld = ((argile_list_t *)ld)->next) {
      argile_def_t * d = ((argile_def_t *)0);

      d = *((argile_def_t * *)&((argile_list_t *)ld)->data);
      if ((((d)->dtype == ARGILE_DEF_BIND) && (((d)->dval).bind == b_3))) {
        if (((opt_2 == NULL) || ((*&(opt_2)[0] == 0) || (argile_def_has_option(d, opt_2))))) {
          return d;
        } //;
        o = 1;
      } //;
    };
  };
  if ((err)) {
    if (o) {
      argile_die("binding '%s' in module '%s' not defined with option '%s'\n  (did you forget to use std ?)", bnd, mod_2, opt_2);
    } //;
    else {
      argile_die("binding '%s' in module '%s' found, but not defined", bnd, mod_2);
    };
  } //;
  return ((argile_def_t *)0);
}

void argile_find_all_autoparams()
/** :argile_find_all_autoparams: -> nothing **/
{
  argile_list_t * ldef;

  if (((argile).main == NULL)) {
    return;
  } //;
  ldef = ((argile).main)->defs;
  for (; (ldef); ldef = ((argile_list_t *)ldef)->next) {
    argile_def_t * d = ((argile_def_t *)0);

    d = *((argile_def_t * *)&((argile_list_t *)ldef)->data);
    if ((((d)->dtype == ARGILE_DEF_FUNC) && (((d)->dval).code))) {
      unsigned char loop;

      loop = 1;
      while (loop) {
        loop = argile_code_find_autoparams(((d)->dval).code);
      };
    } //;
  };
}

void argile_add_gstats()
/** :argile_add_gstats: -> nothing **/
{
  ((argile).gstat).rejsize += ((argile).stat).rejsize;
  ((argile).gstat).rejmaxsize += ((argile).stat).rejmaxsize;
  ((argile).gstat).hitsize += ((argile).stat).hitsize;
  ((argile).gstat).num_match_eq += ((argile).stat).num_match_eq;
  ((argile).gstat).num_match_try += ((argile).stat).num_match_try;
  ((argile).gstat).num_call_compile_as += ((argile).stat).num_call_compile_as;
  ((argile).gstat).vars += ((argile).stat).vars;
  ((argile).gstat).params += ((argile).stat).params;
  ((argile).gstat).funcs += ((argile).stat).funcs;
  ((argile).gstat).macros += ((argile).stat).macros;
  ((argile).gstat).binds += ((argile).stat).binds;
}

static unsigned char is_not_included(argile_code_t * c_2)
/** :<argile code c> is not included: -> bool **/
{
  argile_list_t * cur;

  for (cur = (argile).used; (cur); cur = ((argile_list_t *)cur)->next) {
    if (((*((argile_file_t * *)&((argile_list_t *)cur)->data))->code == c_2)) {
      return 0;
    } //;
  };
  return 1;
}

static unsigned char argile_pos_su_argile_pos(argile_pos_t * a_3, argile_pos_t * b_3)
/** :<pos a> > <pos b>: -> bool **/
{
  if (((a_3)->row == (b_3)->row)) {
    return ((a_3)->col > (b_3)->col);
  } //;
  return ((a_3)->row > (b_3)->row);
}

static void comment(comment_t * c_3)
/** :<comment c>: -> nothing **/
{
  if (((c_3)->txt)) {
    argile_dbg_free((c_3)->txt);
  } //;
  argile_dbg_free(c_3);
}

static void print_define(argile_file_t * * file, int * size, char * * name)
/** :print define: -> nothing **/
{
  argile_output("_", 1);
  argile_output(*name, *size);
  argile_puts("_HEADER_");
  if ((*file)) {
    argile_printf("_device_%lu_inode_%lu_", ((unsigned long)(*file)->device), ((unsigned long)(*file)->inode));
  } //;
}

static int get_word_size_of(char * t_5)
/** :get word size of <text t>: -> int **/
{
  int size_2 = 0;

  while ((((((*&(t_5)[0] >= 'a') && (*&(t_5)[0] <= 'z')) || ((*&(t_5)[0] >= 'A') && (*&(t_5)[0] <= 'Z'))) || ((*&(t_5)[0] >= '0') && (*&(t_5)[0] <= '9'))) || (*&(t_5)[0] == '_'))) {
    (size_2)++;
    (t_5)++;
  };
  return size_2;
}

static void write_ref_or_raw_in_with(argile_buff_t * tb, argile_buff_t * out_3, argile_def_t * d, char * name_5)
/** :write ref or raw <buff tb> in <buff out> with <def d> <text name>: -> nothing **/
{
  if ((d)) {
    argile_syntax_module_call((d)->syntax, tb, (char *)0, ((argile_list_t *)0), out_3);
  } //;
  else {
    argile_buff_puts(out_3, name_5);
    argile_buff_puts(out_3, " to (");
    argile_buff_cat(out_3, tb);
    argile_buff_putc(out_3, *&(")")[0]);
  };
}

static void add_include(char * p)
/** :add include <text p>: -> nothing **/
{
  int n_3 = 0;
  char * h = "";
  int e = 0;

  n_3 = strlen(p);
  h = ((char *)argile_dbg_malloc((n_3 + 3)));
  memcpy(h, p, n_3);
  if (((e = ends_by(p, n_3, ".arg")) || (e = ends_by(p, n_3, ".argl")))) {
    memcpy(((((h) + n_3)) - e), ".h", 3);
  } //;
  else {
    memcpy(((h) + n_3), ".h", 3);
  };
  if ((argile_list_search((argile).includes, h, (void *)&argile_streq))) {
    argile_dbg_free(h);
  } //;
  else {
    argile_list_prepend(&(argile).includes, argile_list_new(h, (void *)&argile_dbg_free));
  };
}

static argile_file_t * try_in_dir(char * path_3, int plen, char * dir, int dlen)
/** :try <text path> <int plen> in dir <text dir> <int dlen>: -> (argile) file **/
{
  int trysize = 0;
  char * trypath = "";
  int end_2 = 0;
  struct stat st = ((struct stat){0});

  trysize = ((dlen + 1) + plen);
  trypath = ((char *)argile_dbg_malloc(trysize));
  memcpy(trypath, dir, dlen);
  snprintf(((trypath) + dlen), (trysize - dlen), "/%s", path_3);
  strip_useless_slashes_in(trypath);
  end_2 = strlen(trypath);
  if (doesn_t_end_by_ext(path_3)) {
    snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".argl");
    if ((cached_stat(trypath, &st) == 0)) {
      argile_file_t * file_2 = ((argile_file_t *)0);
      time_t time;

      file_2 = argile_file_new(trypath, &st);
      time = (st).st_mtime;
      snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".arg");
      if ((stat(trypath, &st) == 0)) {
        argile_file_t * srcfile = ((argile_file_t *)0);

        srcfile = argile_file_new(trypath, &st);
        if (time<(st).st_mtime) {
          if (!((argile_list_search((argile).warns, (file_2)->path, (void *)&argile_streq)))) {
            argile_list_prepend(&(argile).warns, argile_list_new(argile_dbg_strdup((file_2)->path), (void *)&argile_dbg_free));
            fprintf(stderr, "%s: warning: %s is ignored (older than %s)\n", "arc", (file_2)->path, trypath);
          } //;
          argile_file_del(file_2);
          argile_dbg_free(trypath);
          return srcfile;
        } //;
        if ((argile_file_eq(srcfile, (argile).main_file))) {
          argile_file_del(file_2);
          argile_dbg_free(trypath);
          return srcfile;
        } //;
        argile_file_del(srcfile);
        (file_2)->derived = 1;
      } //;
      argile_dbg_free(trypath);
      return file_2;
    } //;
    snprintf(((trypath) + end_2), (trysize - end_2), "%s", ".arg");
    if ((stat(trypath, &st) == 0)) {
      argile_file_t * file_2 = ((argile_file_t *)0);

      file_2 = argile_file_new(trypath, &st);
      argile_dbg_free(trypath);
      return file_2;
    } //;
  } //;
  *&(trypath)[end_2] = '\0';
  if ((stat(trypath, &st) == 0)) {
    argile_file_t * file_2 = ((argile_file_t *)0);

    file_2 = argile_file_new(trypath, &st);
    argile_dbg_free(trypath);
    return file_2;
  } //;
  argile_dbg_free(trypath);
  return ((argile_file_t *)0);
}

static void strip_useless_slashes_in(char * s_2)
/** :strip useless slashes in <text s>: -> nothing **/
{
  while ((*&(s_2)[0] != 0)) {
    if ((*&(s_2)[0] == '/')) {
      int x = 0;

      if (!((strncmp(((s_2) + 1), "./", 2)))) {
        x = 3;
        while (!((strncmp(((s_2) + x), "./", 2)))) {
          x += 2;
        };
        reduce(((s_2) + 1), ((s_2) + x));
      } //;
      else {
        x = 1;
        while ((*&(s_2)[x] == '/')) {
          (x)++;
        };
        reduce(((s_2) + 1), ((s_2) + x));
      };
    } //;
    (s_2)++;
  };
}

static unsigned char doesn_t_end_by_ext(char * str_3)
/** :<text str> doesn ' t end by ext: -> bool **/
{
  int elen = 0;
  int llen = 0;
  int slen = 0;

  elen = strlen(".arg");
  llen = strlen(".argl");
  slen = strlen(str_3);
  if (((slen > elen) && (strcmp(".arg", ((str_3) + (slen - elen))) == 0))) {
    return 0;
  } //;
  if (((slen > llen) && (strcmp(".argl", ((str_3) + (slen - llen))) == 0))) {
    return 0;
  } //;
  return 1;
}

static int cached_stat(char * p_2, struct stat * st_2)
/** :cached - stat <text p> <stat st>: -> int **/
{
  int r = 0;

  if ((argile_list_search((argile).stat_fails, p_2, (void *)&argile_streq))) {
    return -1;
  } //;
  r = stat(p_2, st_2);
  if ((r != 0)) {
    argile_list_prepend(&(argile).stat_fails, argile_list_new(argile_dbg_strdup(p_2), (void *)&argile_dbg_free));
  } //;
  return r;
}

static void reduce(char * d_2, char * s_3)
/** :reduce <text d> <text s>: -> nothing **/
{
  while ((*&(s_3)[0] != 0)) {
    *&((d_2)++)[0] = *&((s_3)++)[0];
  };
  *&(d_2)[0] = *&(s_3)[0];
}

static int id_end_num(char * s_4, unsigned int n_3, int * num_2)
/** :id end num <text s> <nat n> <(int) & num>: -> int **/
{
  int i_2 = 0;
  int u = -1;
  char c_4;

  for (i_2 = 0; (i_2 < n_3); (i_2)++) {
    if ((*&(s_4)[i_2] == '_')) {
      u = i_2;
    } //;
  };
  if (((u <= 0) || (*&(s_4)[(u + 1)] == 0))) {
    return (n_3 - 1);
  } //;
  for (i_2 = (u + 1); (c_4 = *&(s_4)[i_2]); (i_2)++) {
    if (((c_4 < '0') || (c_4 > '9'))) {
      return (n_3 - 1);
    } //;
  };
  *num_2 = atoi(((s_4) + (u + 1)));
  return u;
}

static void check_id_num(argile_buff_t * b_4, char * id, unsigned char * found_2, int * min_2, int * max_2)
/** :check id num <buff b> <text id> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
{
  int i_2 = 0;

  i_2 = ((b_4)->len - 1);
  if (((id) && !((strncmp(id, (b_4)->ptr, i_2))))) {
    if ((*&(id)[i_2] == 0)) {
      *found_2 = 1;
    } //;
    else if ((*&(id)[i_2] == '_')) {
      do {
        (i_2)++;
      } while (((*&(id)[i_2] >= '0') && (*&(id)[i_2] <= '9')));
      if ((*&(id)[i_2] == 0)) {
        i_2 = atoi(((id) + (b_4)->len));
        if ((i_2 > *max_2)) {
          *max_2 = i_2;
        } //;
        if (((*min_2 < 0) || (i_2 < *min_2))) {
          *min_2 = i_2;
        } //;
      } //;
    } //;
  } //;
}

static void check_call_id_num(argile_call_t * p_argile_call, argile_buff_t * b_5, unsigned char * found_3, int * min_3, int * max_3)
/** :check call id num <call> <buff b> <(bool) & found> <(int) & min> <(int) & max>: -> nothing **/
{
  argile_list_t * lm;

  for (lm = (p_argile_call)->match; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m_2 = ((argile_match_t *)0);

    m_2 = ((argile_match_t *)*((void * *)&((argile_list_t *)lm)->data.u_anything));
    if ((m_2 == NULL)) {
      continue;
    } //;
    if (((m_2)->type == ARGILE_MATCH_SUBCALL)) {
      check_call_id_num(((m_2)->value).call, b_5, found_3, min_3, max_3);
    } //;
    else if (((m_2)->type == ARGILE_MATCH_CONS)) {
      argile_cons_t * cons = ((argile_cons_t *)0);

      cons = ((m_2)->value).cons;
      if (((cons)->ctype == ARGILE_CONS_CODE)) {
        check_id_num(b_5, (((cons)->cvalue).code)->anon, found_3, min_3, max_3);
      } //;
    } //;
  };
}

static void search_in_with(argile_list_t * syn, argile_code_t * code_3, void (* callback_2)(argile_def_t *))
/** :search <list of (argile syntax) syn> in <argile code code> with <function (def) callback>: -> nothing **/
{
  argile_list_t * ld;
  argile_list_t * lc;

  ld = (code_3)->defs;
  for (; (ld); ld = ((argile_list_t *)ld)->next) {
    argile_def_t * d_3 = ((argile_def_t *)0);

    d_3 = *((argile_def_t * *)&((argile_list_t *)ld)->data);
    if (((d_3)->maker == NULL)) {
      continue;
    } //;
    if ((argile_syntax_match((d_3)->syntax, syn))) {
      (*callback_2)(d_3);
    } //;
  };
  lc = (code_3)->calls;
  for (; (lc); lc = ((argile_list_t *)lc)->next) {
    search_in_with_2(syn, *((argile_call_t * *)&((argile_list_t *)lc)->data), callback_2);
  };
}

static void search_in_with_2(argile_list_t * syn_2, argile_call_t * p_argile_call_2, void (* callback_3)(argile_def_t *))
/** :search <list of (argile syntax) syn> in <call> with <function (def) callback>: -> nothing **/
{
  argile_list_t * lm;

  lm = (p_argile_call_2)->match;
  for (; (lm); lm = ((argile_list_t *)lm)->next) {
    argile_match_t * m_2 = ((argile_match_t *)0);

    m_2 = *((argile_match_t * *)&((argile_list_t *)lm)->data);
    if ((m_2 == NULL)) {
      continue;
    } //;
    if (((m_2)->type == ARGILE_MATCH_SUBCALL)) {
      search_in_with_2(syn_2, ((m_2)->value).call, callback_3);
    } //;
    else if ((((m_2)->type == ARGILE_MATCH_CONS) && ((((m_2)->value).cons)->ctype == ARGILE_CONS_CODE))) {
      search_in_with(syn_2, ((((m_2)->value).cons)->cvalue).code, callback_3);
    } //;
  };
}

static void split_op(char * str_4, int len_5, int optoken)
/** :split op <text str> <int len> <int optoken>: -> nothing **/
{
  char * cpy = "";

  cpy = ((char *)argile_dbg_malloc((len_5 + 1)));
  argile_add_leak(cpy);
  memcpy(cpy, str_4, len_5);
  *&(cpy)[len_5] = '\0';
  argile_push_op(cpy);
  argile_push_optoken(optoken);
}

static argile_list_t * new_range(unsigned int a_4, unsigned int b_6)
/** :new range <nat a> <nat b>: -> list of (array of (nat)) **/
{
  unsigned int(* r);

  r = ((unsigned int(*))argile_dbg_malloc((2 * sizeof(unsigned int))));
  *&(r)[0] = a_4;
  *&(r)[1] = b_6;
  return argile_list_new(r, (void *)&argile_dbg_free);
}

