//  Copyright (C) 2011 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef RAFTLIST_H
#define RAFTLIST_H

#include <string>
#include "vector.h"
#include <sigc++/trackable.h>

class XML_Helper;
class Raft;
class Raftlist : public std::list<Raft*>, public sigc::trackable
{
    public:
	//! The xml tag of this object in a saved-game file.
	static std::string d_tag; 

	// Methods that operate on the class data but do not modify the class.

        //! Saves the list of rafts to the opened saved-game file.
        bool save(XML_Helper* helper) const;

	// Static Methods

        //! Return the singleton instance.  Create a new one if needed.
        static Raftlist* getInstance();

        //! Load the singleton instance from the opened saved-game file.
        static Raftlist* getInstance(XML_Helper* helper);

        //! Explicitly delete the singleton instance.
        static void deleteInstance();
        
    protected:
        //! Default constructor.
        Raftlist();

        //! Loading constructor.
	/**
	 * Make a new raftlist object by loading it from the opened saved-game
	 * file.
	 *
	 * @param helper  The opened saved game file to load the list of rafts
	 *                from.
	 */
        Raftlist(XML_Helper* helper);

    private:
        //! Callback for loading raft objects into the list.
        bool load(std::string tag, XML_Helper* helper);

        //! A static pointer for the singleton instance.
        static Raftlist* s_instance;
};

#endif
